/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import com.google.common.collect.ImmutableList;
import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.BinaryEncoding;
import io.trino.hive.formats.encodings.text.BooleanEncoding;
import io.trino.hive.formats.encodings.text.DateEncoding;
import io.trino.hive.formats.encodings.text.DecimalEncoding;
import io.trino.hive.formats.encodings.text.DoubleEncoding;
import io.trino.hive.formats.encodings.text.FloatEncoding;
import io.trino.hive.formats.encodings.text.ListEncoding;
import io.trino.hive.formats.encodings.text.LongEncoding;
import io.trino.hive.formats.encodings.text.MapEncoding;
import io.trino.hive.formats.encodings.text.StringEncoding;
import io.trino.hive.formats.encodings.text.StructEncoding;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.hive.formats.encodings.text.TextEncodingOptions;
import io.trino.hive.formats.encodings.text.TimestampEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;

public class TextColumnEncodingFactory
implements ColumnEncodingFactory {
    private final TextEncodingOptions textEncodingOptions;

    public TextColumnEncodingFactory() {
        this(TextEncodingOptions.builder().build());
    }

    public TextColumnEncodingFactory(TextEncodingOptions textEncodingOptions) {
        this.textEncodingOptions = Objects.requireNonNull(textEncodingOptions, "simpleOptions is null");
    }

    @Override
    public TextColumnEncoding getEncoding(Type type) {
        try {
            return this.getEncoding(type, 0);
        }
        catch (NotEnoughSeparatorsException e) {
            if (e.getDepth() > TextEncodingOptions.NestingLevels.EXTENDED_ADDITIONAL.getLevels()) {
                throw new IllegalArgumentException(String.format("Type %s requires %s nesting levels, which is not possible", type, e.getDepth()));
            }
            if (e.getDepth() > TextEncodingOptions.NestingLevels.EXTENDED.getLevels()) {
                throw new IllegalArgumentException(String.format("Type %s requires %s nesting levels, which can be enabled with the %s table property", type, e.getDepth(), TextEncodingOptions.NestingLevels.EXTENDED_ADDITIONAL.getTableProperty()));
            }
            throw new IllegalArgumentException(String.format("Type %s requires %s nesting levels, which can be enabled with the %s table property", type, e.getDepth(), TextEncodingOptions.NestingLevels.EXTENDED.getTableProperty()));
        }
    }

    private TextColumnEncoding getEncoding(Type type, int depth) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanEncoding(type, this.textEncodingOptions.getNullSequence());
        }
        if (TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            return new LongEncoding(type, this.textEncodingOptions.getNullSequence());
        }
        if (type instanceof DecimalType) {
            return new DecimalEncoding(type, this.textEncodingOptions.getNullSequence());
        }
        if (RealType.REAL.equals((Object)type)) {
            return new FloatEncoding(type, this.textEncodingOptions.getNullSequence());
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleEncoding(type, this.textEncodingOptions.getNullSequence());
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return new StringEncoding(type, this.textEncodingOptions.getNullSequence(), this.textEncodingOptions.getEscapeByte(), this.textEncodingOptions.getSeparators());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new BinaryEncoding(type, this.textEncodingOptions.getNullSequence());
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateEncoding(type, this.textEncodingOptions.getNullSequence());
        }
        if (type instanceof TimestampType) {
            return new TimestampEncoding((TimestampType)type, this.textEncodingOptions.getNullSequence(), this.textEncodingOptions.getTimestampFormats());
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            TextColumnEncoding elementEncoding = this.getEncoding(arrayType.getElementType(), depth + 1);
            return new ListEncoding(arrayType, this.textEncodingOptions.getNullSequence(), this.getSeparator(depth + 1), this.textEncodingOptions.getEscapeByte(), elementEncoding);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            TextColumnEncoding keyEncoding = this.getEncoding(mapType.getKeyType(), depth + 2);
            TextColumnEncoding valueEncoding = this.getEncoding(mapType.getValueType(), depth + 2);
            return new MapEncoding(mapType, this.textEncodingOptions.getNullSequence(), this.getSeparator(depth + 1), this.getSeparator(depth + 2), this.textEncodingOptions.getEscapeByte(), keyEncoding, valueEncoding);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List fieldEncodings = (List)rowType.getTypeParameters().stream().map(fieldType -> this.getEncoding((Type)fieldType, depth + 1)).collect(ImmutableList.toImmutableList());
            return new StructEncoding(rowType, this.textEncodingOptions.getNullSequence(), this.getSeparator(depth + 1), this.textEncodingOptions.getEscapeByte(), this.textEncodingOptions.isLastColumnTakesRest(), fieldEncodings);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + String.valueOf(type));
    }

    private byte getSeparator(int depth) {
        if (depth >= this.textEncodingOptions.getSeparators().length()) {
            throw new NotEnoughSeparatorsException(depth);
        }
        return this.textEncodingOptions.getSeparators().getByte(depth);
    }

    private static class NotEnoughSeparatorsException
    extends RuntimeException {
        private final int depth;

        public NotEnoughSeparatorsException(int depth) {
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

