/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.DistinctMapKeys;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTimeZone;

public class JsonDeserializer
implements LineDeserializer {
    private static final JsonFactory JSON_FACTORY = ((JsonFactoryBuilder)JsonUtils.jsonFactoryBuilder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).build();
    private final List<Type> types;
    private final RowDecoder rowDecoder;

    public JsonDeserializer(List<Column> columns, List<String> timestampFormats) {
        this.types = (List)columns.stream().map(Column::type).collect(ImmutableList.toImmutableList());
        Function<String, DecodedTimestamp> timestampParser = HiveFormatUtils.createTimestampParser(timestampFormats);
        ImmutableMap.Builder ordinals = ImmutableMap.builderWithExpectedSize((int)columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            ordinals.put((Object)columns.get(i).ordinal(), (Object)i);
        }
        ImmutableMap topLevelOrdinalMap = ordinals.buildOrThrow();
        this.rowDecoder = new RowDecoder(RowType.from((List)((List)columns.stream().map(column -> RowType.field((String)column.name().toLowerCase(Locale.ROOT), (Type)column.type())).collect(ImmutableList.toImmutableList()))), (List)columns.stream().map(Column::type).map(fieldType -> JsonDeserializer.createDecoder(fieldType, timestampParser)).collect(ImmutableList.toImmutableList()), ((Map)topLevelOrdinalMap)::get);
    }

    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void deserialize(LineBuffer lineBuffer, PageBuilder builder) throws IOException {
        JsonParser parser = JSON_FACTORY.createParser(lineBuffer.getBuffer(), 0, lineBuffer.getLength());
        parser.nextToken();
        this.rowDecoder.decode(parser, builder);
        parser.close();
    }

    private static Decoder createDecoder(Type type, Function<String, DecodedTimestamp> timestampParser) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanDecoder();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return new BigintDecoder();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return new IntegerDecoder();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return new SmallintDecoder();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return new TinyintDecoder();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalDecoder(decimalType);
        }
        if (RealType.REAL.equals((Object)type)) {
            return new RealDecoder();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleDecoder();
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateDecoder();
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return new TimestampDecoder(timestampType, timestampParser);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new VarbinaryDecoder();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return new VarcharDecoder(varcharType);
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return new CharDecoder(charType);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ArrayDecoder(arrayType, JsonDeserializer.createDecoder(arrayType.getElementType(), timestampParser));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapDecoder(mapType, JsonDeserializer.createDecoder(mapType.getValueType(), timestampParser), timestampParser);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return new RowDecoder(rowType, (List)rowType.getFields().stream().map(RowType.Field::getType).map(fieldType -> JsonDeserializer.createDecoder(fieldType, timestampParser)).collect(ImmutableList.toImmutableList()), IntUnaryOperator.identity());
        }
        throw new UnsupportedOperationException("Unsupported column type: " + String.valueOf(type));
    }

    private static void skipNextValue(JsonParser parser) throws IOException {
        JsonToken valueToken = parser.nextToken();
        if (valueToken == JsonToken.START_ARRAY || valueToken == JsonToken.START_OBJECT) {
            parser.skipChildren();
        }
    }

    private static boolean nextObjectField(JsonParser parser) throws IOException {
        JsonToken token = JsonDeserializer.nextTokenRequired(parser);
        if (token == JsonToken.FIELD_NAME) {
            return true;
        }
        if (token == JsonToken.END_OBJECT) {
            return false;
        }
        throw JsonDeserializer.invalidJson("field name expected");
    }

    private static JsonToken nextTokenRequired(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == null) {
            throw JsonDeserializer.invalidJson("object is truncated");
        }
        return token;
    }

    private static IOException invalidJson(String message) {
        return new IOException("Invalid JSON: " + message);
    }

    private static class RowDecoder
    extends Decoder {
        private static final Pattern INTERNAL_PATTERN = Pattern.compile("_col([0-9]+)");
        private final Map<String, Integer> fieldPositions;
        private final List<Decoder> fieldDecoders;
        private final IntUnaryOperator ordinalToFieldPosition;

        public RowDecoder(RowType rowType, List<Decoder> fieldDecoders, IntUnaryOperator ordinalToFieldPosition) {
            super((Type)rowType);
            ImmutableMap.Builder fieldPositions = ImmutableMap.builder();
            List fields = rowType.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                fieldPositions.put((Object)((String)field.getName().orElseThrow()).toLowerCase(Locale.ROOT), (Object)i);
            }
            this.fieldPositions = fieldPositions.buildOrThrow();
            this.fieldDecoders = fieldDecoders;
            this.ordinalToFieldPosition = ordinalToFieldPosition;
        }

        public void decode(JsonParser parser, PageBuilder builder) throws IOException {
            builder.declarePosition();
            this.decodeValue(parser, builder.getPositionCount(), arg_0 -> ((PageBuilder)builder).getBlockBuilder(arg_0));
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> this.decodeValue(parser, builder.getPositionCount(), fieldBuilders::get));
        }

        private void decodeValue(JsonParser parser, int currentPosition, IntFunction<BlockBuilder> fieldBuilders) throws IOException {
            if (parser.currentToken() != JsonToken.START_OBJECT) {
                throw JsonDeserializer.invalidJson("start of object expected");
            }
            boolean[] fieldWritten = new boolean[this.fieldDecoders.size()];
            while (JsonDeserializer.nextObjectField(parser)) {
                String fieldName = parser.getText();
                int rowIndex = this.getFieldPosition(fieldName);
                if (rowIndex < 0) {
                    JsonDeserializer.skipNextValue(parser);
                    continue;
                }
                BlockBuilder fieldBuilder = fieldBuilders.apply(rowIndex);
                if (fieldWritten[rowIndex]) {
                    fieldBuilder.resetTo(currentPosition);
                }
                JsonDeserializer.nextTokenRequired(parser);
                this.fieldDecoders.get(rowIndex).decode(parser, fieldBuilder);
                fieldWritten[rowIndex] = true;
            }
            for (int i = 0; i < fieldWritten.length; ++i) {
                if (fieldWritten[i]) continue;
                fieldBuilders.apply(i).appendNull();
            }
        }

        private int getFieldPosition(String fieldName) {
            Integer fieldPosition = this.fieldPositions.get(fieldName.toLowerCase(Locale.ROOT));
            if (fieldPosition != null) {
                return fieldPosition;
            }
            Matcher matcher = INTERNAL_PATTERN.matcher(fieldName);
            if (!matcher.matches()) {
                return -1;
            }
            int ordinal = Integer.parseInt(matcher.group(1));
            return this.ordinalToFieldPosition.applyAsInt(ordinal);
        }
    }

    private static class BooleanDecoder
    extends Decoder {
        public BooleanDecoder() {
            super((Type)BooleanType.BOOLEAN);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            BooleanType.BOOLEAN.writeBoolean(builder, Boolean.parseBoolean(parser.getText()));
        }
    }

    private static class BigintDecoder
    extends Decoder {
        public BigintDecoder() {
            super((Type)BigintType.BIGINT);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            BigintType.BIGINT.writeLong(builder, parser.getLongValue());
        }
    }

    private static class IntegerDecoder
    extends Decoder {
        public IntegerDecoder() {
            super((Type)IntegerType.INTEGER);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            IntegerType.INTEGER.writeLong(builder, (long)parser.getIntValue());
        }
    }

    private static class SmallintDecoder
    extends Decoder {
        public SmallintDecoder() {
            super((Type)SmallintType.SMALLINT);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            SmallintType.SMALLINT.writeLong(builder, (long)parser.getShortValue());
        }
    }

    private static class TinyintDecoder
    extends Decoder {
        public TinyintDecoder() {
            super((Type)TinyintType.TINYINT);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            TinyintType.TINYINT.writeLong(builder, (long)parser.getByteValue());
        }
    }

    private static class DecimalDecoder
    extends Decoder {
        private final DecimalType decimalType;

        public DecimalDecoder(DecimalType decimalType) {
            super((Type)decimalType);
            this.decimalType = decimalType;
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            BigDecimal bigDecimal;
            String value = parser.getText();
            try {
                bigDecimal = HiveFormatUtils.parseDecimal(value, this.decimalType);
            }
            catch (NumberFormatException numberFormatException) {
                builder.appendNull();
                return;
            }
            if (Decimals.overflows((BigDecimal)bigDecimal, (long)this.decimalType.getPrecision())) {
                throw new NumberFormatException(String.format("Cannot convert '%s' to %s. Value too large.", value, this.decimalType));
            }
            if (this.decimalType.isShort()) {
                this.decimalType.writeLong(builder, bigDecimal.unscaledValue().longValueExact());
            } else {
                this.decimalType.writeObject(builder, (Object)Int128.valueOf((BigInteger)bigDecimal.unscaledValue()));
            }
        }
    }

    private static class RealDecoder
    extends Decoder {
        public RealDecoder() {
            super((Type)RealType.REAL);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(parser.getFloatValue()));
        }
    }

    private static class DoubleDecoder
    extends Decoder {
        public DoubleDecoder() {
            super((Type)DoubleType.DOUBLE);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            DoubleType.DOUBLE.writeDouble(builder, parser.getDoubleValue());
        }
    }

    private static class DateDecoder
    extends Decoder {
        public DateDecoder() {
            super((Type)DateType.DATE);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            DateType.DATE.writeLong(builder, (long)StrictMath.toIntExact(HiveFormatUtils.parseHiveDate(parser.getText()).toEpochDay()));
        }
    }

    private static class TimestampDecoder
    extends Decoder {
        private final TimestampType timestampType;
        private final Function<String, DecodedTimestamp> timestampParser;

        public TimestampDecoder(TimestampType timestampType, Function<String, DecodedTimestamp> timestampParser) {
            super((Type)timestampType);
            this.timestampType = timestampType;
            this.timestampParser = timestampParser;
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            DecodedTimestamp timestamp = this.timestampParser.apply(parser.getText());
            TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)this.timestampType, (DateTimeZone)DateTimeZone.UTC).write(timestamp, builder);
        }
    }

    private static class VarbinaryDecoder
    extends Decoder {
        private final CharsetDecoder charsetDecoder = VarbinaryDecoder.createCharsetDecoder();

        public VarbinaryDecoder() {
            super((Type)VarbinaryType.VARBINARY);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            VarbinaryType.VARBINARY.writeSlice(builder, VarbinaryDecoder.parseBinary(parser.getText(), this.charsetDecoder));
        }

        private static Slice parseBinary(String value, CharsetDecoder charsetDecoder) throws IOException {
            byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
            String decode = charsetDecoder.decode(ByteBuffer.wrap(utf8, 0, utf8.length)).toString();
            return Slices.utf8Slice((String)decode);
        }

        private static CharsetDecoder createCharsetDecoder() {
            return StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
    }

    private static class VarcharDecoder
    extends Decoder {
        private final VarcharType varcharType;

        public VarcharDecoder(VarcharType varcharType) {
            super((Type)varcharType);
            this.varcharType = varcharType;
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            this.varcharType.writeSlice(builder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)parser.getText()), (VarcharType)this.varcharType));
        }
    }

    private static class CharDecoder
    extends Decoder {
        private final CharType charType;

        public CharDecoder(CharType charType) {
            super((Type)charType);
            this.charType = charType;
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            this.charType.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)parser.getText()), (CharType)this.charType));
        }
    }

    private static class ArrayDecoder
    extends Decoder {
        private final Decoder elementDecoder;

        public ArrayDecoder(ArrayType arrayType, Decoder elementDecoder) {
            super((Type)arrayType);
            this.elementDecoder = elementDecoder;
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            ((ArrayBlockBuilder)builder).buildEntry(elementBuilder -> {
                if (parser.currentToken() != JsonToken.START_ARRAY) {
                    throw JsonDeserializer.invalidJson("start of array expected");
                }
                while (JsonDeserializer.nextTokenRequired(parser) != JsonToken.END_ARRAY) {
                    this.elementDecoder.decode(parser, elementBuilder);
                }
            });
        }
    }

    private static abstract class Decoder {
        private final Type type;

        public Decoder(Type type) {
            this.type = type;
        }

        public final void decode(JsonParser parser, BlockBuilder builder) throws IOException {
            if (parser.currentToken() == JsonToken.VALUE_NULL) {
                builder.appendNull();
                return;
            }
            if (Decoder.isScalarType(this.type) && !parser.currentToken().isScalarValue()) {
                throw JsonDeserializer.invalidJson(String.valueOf(this.type) + " value must be a scalar json value");
            }
            this.decodeValue(parser, builder);
        }

        abstract void decodeValue(JsonParser var1, BlockBuilder var2) throws IOException;

        private static boolean isScalarType(Type type) {
            return !(type instanceof ArrayType) && !(type instanceof MapType) && !(type instanceof RowType);
        }
    }

    private static class MapDecoder
    extends Decoder {
        private final Decoder valueDecoder;
        private final Type keyType;
        private final Type valueType;
        private final Function<String, DecodedTimestamp> timestampParser;
        private final CharsetDecoder charsetDecoder = VarbinaryDecoder.createCharsetDecoder();
        private final DistinctMapKeys distinctMapKeys;
        private BlockBuilder keyBlockBuilder;
        private BlockBuilder valueBlockBuilder;

        public MapDecoder(MapType mapType, Decoder valueDecoder, Function<String, DecodedTimestamp> timestampParser) {
            super((Type)mapType);
            this.keyType = mapType.getKeyType();
            this.valueType = mapType.getValueType();
            this.valueDecoder = valueDecoder;
            this.timestampParser = timestampParser;
            this.distinctMapKeys = new DistinctMapKeys(mapType, true);
            this.keyBlockBuilder = mapType.getKeyType().createBlockBuilder(null, 128);
            this.valueBlockBuilder = mapType.getValueType().createBlockBuilder(null, 128);
        }

        @Override
        void decodeValue(JsonParser parser, BlockBuilder builder) throws IOException {
            if (parser.currentToken() != JsonToken.START_OBJECT) {
                throw JsonDeserializer.invalidJson("start of object expected");
            }
            while (JsonDeserializer.nextObjectField(parser)) {
                String keyText = parser.getText();
                this.serializeMapKey(keyText, this.keyType, this.keyBlockBuilder);
                parser.nextToken();
                this.valueDecoder.decode(parser, this.valueBlockBuilder);
            }
            ValueBlock keys = this.keyBlockBuilder.buildValueBlock();
            ValueBlock values = this.valueBlockBuilder.buildValueBlock();
            this.keyBlockBuilder = this.keyType.createBlockBuilder(null, keys.getPositionCount());
            this.valueBlockBuilder = this.valueType.createBlockBuilder(null, values.getPositionCount());
            boolean[] distinctKeys = this.distinctMapKeys.selectDistinctKeys((Block)keys);
            ((MapBlockBuilder)builder).buildEntry((keyBuilder, valueBuilder) -> {
                for (int index = 0; index < distinctKeys.length; ++index) {
                    boolean distinctKey = distinctKeys[index];
                    if (!distinctKey) continue;
                    keyBuilder.append(keys, index);
                    valueBuilder.append(values, index);
                }
            });
        }

        private void serializeMapKey(String value, Type type, BlockBuilder builder) throws IOException {
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                type.writeBoolean(builder, Boolean.parseBoolean(value));
            } else if (BigintType.BIGINT.equals((Object)type)) {
                type.writeLong(builder, Long.parseLong(value));
            } else if (IntegerType.INTEGER.equals((Object)type)) {
                type.writeLong(builder, (long)Integer.parseInt(value));
            } else if (SmallintType.SMALLINT.equals((Object)type)) {
                type.writeLong(builder, (long)Short.parseShort(value));
            } else if (TinyintType.TINYINT.equals((Object)type)) {
                type.writeLong(builder, (long)Byte.parseByte(value));
            } else if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                HiveFormatUtils.writeDecimal(value, decimalType, builder);
            } else if (RealType.REAL.equals((Object)type)) {
                type.writeLong(builder, (long)Float.floatToRawIntBits(Float.parseFloat(value)));
            } else if (DoubleType.DOUBLE.equals((Object)type)) {
                type.writeDouble(builder, Double.parseDouble(value));
            } else if (DateType.DATE.equals((Object)type)) {
                type.writeLong(builder, HiveFormatUtils.parseHiveDate(value).toEpochDay());
            } else if (type instanceof TimestampType) {
                TimestampType timestampType = (TimestampType)type;
                DecodedTimestamp timestamp = this.timestampParser.apply(value);
                TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)timestampType, (DateTimeZone)DateTimeZone.UTC).write(timestamp, builder);
            } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
                type.writeSlice(builder, VarbinaryDecoder.parseBinary(value, this.charsetDecoder));
            } else if (type instanceof VarcharType) {
                VarcharType varcharType = (VarcharType)type;
                type.writeSlice(builder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value), (VarcharType)varcharType));
            } else if (type instanceof CharType) {
                CharType charType = (CharType)type;
                type.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)value), (CharType)charType));
            } else {
                throw new UnsupportedOperationException("Unsupported map key type: " + String.valueOf(type));
            }
        }
    }
}

