/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.switching;

import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.UriLocation;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SwitchingFileSystem
implements TrinoFileSystem {
    private final Optional<ConnectorSession> session;
    private final Optional<ConnectorIdentity> identity;
    private final Function<Location, TrinoFileSystemFactory> loader;

    public SwitchingFileSystem(Optional<ConnectorSession> session, Optional<ConnectorIdentity> identity, Function<Location, TrinoFileSystemFactory> loader) {
        Preconditions.checkArgument((session.isPresent() != identity.isPresent() ? 1 : 0) != 0, (Object)"exactly one of session and identity must be present");
        this.session = session;
        this.identity = identity;
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    @Override
    public TrinoInputFile newInputFile(Location location) {
        return this.fileSystem(location).newInputFile(location);
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length) {
        return this.fileSystem(location).newInputFile(location, length);
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length, Instant lastModified) {
        return this.fileSystem(location).newInputFile(location, length, lastModified);
    }

    @Override
    public TrinoOutputFile newOutputFile(Location location) {
        return this.fileSystem(location).newOutputFile(location);
    }

    @Override
    public void deleteFile(Location location) throws IOException {
        this.fileSystem(location).deleteFile(location);
    }

    @Override
    public void deleteFiles(Collection<Location> locations) throws IOException {
        Map<TrinoFileSystemFactory, List<Location>> groups = locations.stream().collect(Collectors.groupingBy(this.loader));
        for (Map.Entry<TrinoFileSystemFactory, List<Location>> entry : groups.entrySet()) {
            this.createFileSystem(entry.getKey()).deleteFiles((Collection<Location>)entry.getValue());
        }
    }

    @Override
    public void deleteDirectory(Location location) throws IOException {
        this.fileSystem(location).deleteDirectory(location);
    }

    @Override
    public void renameFile(Location source, Location target) throws IOException {
        this.fileSystem(source).renameFile(source, target);
    }

    @Override
    public FileIterator listFiles(Location location) throws IOException {
        return this.fileSystem(location).listFiles(location);
    }

    @Override
    public Optional<Boolean> directoryExists(Location location) throws IOException {
        return this.fileSystem(location).directoryExists(location);
    }

    @Override
    public void createDirectory(Location location) throws IOException {
        this.fileSystem(location).createDirectory(location);
    }

    @Override
    public void renameDirectory(Location source, Location target) throws IOException {
        this.fileSystem(source).renameDirectory(source, target);
    }

    @Override
    public Set<Location> listDirectories(Location location) throws IOException {
        return this.fileSystem(location).listDirectories(location);
    }

    @Override
    public Optional<Location> createTemporaryDirectory(Location targetPath, String temporaryPrefix, String relativePrefix) throws IOException {
        return this.fileSystem(targetPath).createTemporaryDirectory(targetPath, temporaryPrefix, relativePrefix);
    }

    @Override
    public Optional<UriLocation> preSignedUri(Location targetPath, Duration ttl) throws IOException {
        return this.fileSystem(targetPath).preSignedUri(targetPath, ttl);
    }

    @Override
    public TrinoInputFile newEncryptedInputFile(Location location, EncryptionKey key) {
        return this.fileSystem(location).newEncryptedInputFile(location, key);
    }

    @Override
    public TrinoInputFile newEncryptedInputFile(Location location, long length, EncryptionKey key) {
        return this.fileSystem(location).newEncryptedInputFile(location, length, key);
    }

    @Override
    public TrinoInputFile newEncryptedInputFile(Location location, long length, Instant lastModified, EncryptionKey key) {
        return this.fileSystem(location).newEncryptedInputFile(location, length, lastModified, key);
    }

    @Override
    public TrinoOutputFile newEncryptedOutputFile(Location location, EncryptionKey key) {
        return this.fileSystem(location).newEncryptedOutputFile(location, key);
    }

    @Override
    public Optional<UriLocation> encryptedPreSignedUri(Location location, Duration ttl, EncryptionKey key) throws IOException {
        return this.fileSystem(location).encryptedPreSignedUri(location, ttl, key);
    }

    private TrinoFileSystem fileSystem(Location location) {
        return this.createFileSystem(this.loader.apply(location));
    }

    private TrinoFileSystem createFileSystem(TrinoFileSystemFactory factory) {
        return this.session.map(factory::create).orElseGet(() -> factory.create(this.identity.orElseThrow()));
    }
}

