/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.orc.metadata.statistics.StatisticsHasher;

public class BinaryStatistics
implements StatisticsHasher.Hashable {
    public static final long BINARY_VALUE_BYTES_OVERHEAD = 5L;
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BinaryStatistics.class);
    private final long sum;

    public BinaryStatistics(long sum) {
        this.sum = sum;
    }

    public long getSum() {
        return this.sum;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sum", this.sum).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putLong(this.sum);
    }
}

