/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.orc.metadata.statistics.RangeStatistics;
import io.trino.orc.metadata.statistics.StatisticsHasher;
import java.util.Objects;

public class DoubleStatistics
implements RangeStatistics<Double>,
StatisticsHasher.Hashable {
    public static final long DOUBLE_VALUE_BYTES = 9L;
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DoubleStatistics.class);
    private final boolean hasMinimum;
    private final boolean hasMaximum;
    private final double minimum;
    private final double maximum;

    public DoubleStatistics(Double minimum, Double maximum) {
        Preconditions.checkArgument((minimum == null || !minimum.isNaN() ? 1 : 0) != 0, (Object)"minimum is NaN");
        Preconditions.checkArgument((maximum == null || !maximum.isNaN() ? 1 : 0) != 0, (Object)"maximum is NaN");
        Preconditions.checkArgument((minimum == null || maximum == null || minimum <= maximum ? 1 : 0) != 0, (String)"minimum is not less than or equal to maximum: %s, %s", (Object)minimum, (Object)maximum);
        this.hasMinimum = minimum != null;
        this.minimum = this.hasMinimum ? minimum : 0.0;
        this.hasMaximum = maximum != null;
        this.maximum = this.hasMaximum ? maximum : 0.0;
    }

    @Override
    public Double getMin() {
        return this.hasMinimum ? Double.valueOf(this.minimum) : null;
    }

    @Override
    public Double getMax() {
        return this.hasMaximum ? Double.valueOf(this.maximum) : null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleStatistics that = (DoubleStatistics)o;
        return Objects.equals(this.getMin(), that.getMin()) && Objects.equals(this.getMax(), that.getMax());
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.getMin()).add("max", (Object)this.getMax()).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putOptionalDouble(this.hasMinimum, this.minimum).putOptionalDouble(this.hasMaximum, this.maximum);
    }
}

