/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.airlift.stats.CounterStat;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationOutcome;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class BigQueryArrowAllocatorStats
implements AllocationListener {
    private final CounterStat preAllocatedMemory = new CounterStat();
    private final CounterStat allocatedMemory = new CounterStat();
    private final CounterStat releasedMemory = new CounterStat();
    private final CounterStat failedMemory = new CounterStat();

    @Managed
    @Nested
    public CounterStat getAllocatedMemory() {
        return this.allocatedMemory;
    }

    @Managed
    @Nested
    public CounterStat getReleasedMemory() {
        return this.releasedMemory;
    }

    @Managed
    @Nested
    public CounterStat getPreAllocatedMemory() {
        return this.preAllocatedMemory;
    }

    @Managed
    @Nested
    public CounterStat getFailedMemory() {
        return this.failedMemory;
    }

    public void onAllocation(long size) {
        this.allocatedMemory.update(size);
    }

    public void onRelease(long size) {
        this.releasedMemory.update(size);
    }

    public void onPreAllocation(long size) {
        this.preAllocatedMemory.update(size);
    }

    public boolean onFailedAllocation(long size, AllocationOutcome outcome) {
        this.failedMemory.update(size);
        return false;
    }
}

