/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryLabelFactory;
import io.trino.plugin.bigquery.BigQueryOptionsConfigurer;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.IdentityCacheMapping;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class BigQueryClientFactory {
    private final IdentityCacheMapping identityCacheMapping;
    private final BigQueryTypeManager typeManager;
    private final Optional<String> projectId;
    private final boolean caseInsensitiveNameMatching;
    private final Duration caseInsensitiveNameMatchingCacheTtl;
    private final ViewMaterializationCache materializationCache;
    private final BigQueryLabelFactory labelFactory;
    private final NonEvictableCache<IdentityCacheMapping.IdentityCacheKey, BigQueryClient> clientCache;
    private final Duration metadataCacheTtl;
    private final Set<BigQueryOptionsConfigurer> optionsConfigurers;

    @Inject
    public BigQueryClientFactory(IdentityCacheMapping identityCacheMapping, BigQueryTypeManager typeManager, BigQueryConfig bigQueryConfig, ViewMaterializationCache materializationCache, BigQueryLabelFactory labelFactory, Set<BigQueryOptionsConfigurer> optionsConfigurers) {
        this.identityCacheMapping = Objects.requireNonNull(identityCacheMapping, "identityCacheMapping is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(bigQueryConfig, "bigQueryConfig is null");
        this.projectId = bigQueryConfig.getProjectId();
        this.caseInsensitiveNameMatching = bigQueryConfig.isCaseInsensitiveNameMatching();
        this.caseInsensitiveNameMatchingCacheTtl = bigQueryConfig.getCaseInsensitiveNameMatchingCacheTtl();
        this.materializationCache = Objects.requireNonNull(materializationCache, "materializationCache is null");
        this.labelFactory = Objects.requireNonNull(labelFactory, "labelFactory is null");
        this.metadataCacheTtl = bigQueryConfig.getMetadataCacheTtl();
        this.optionsConfigurers = Objects.requireNonNull(optionsConfigurers, "optionsConfigurers is null");
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(bigQueryConfig.getServiceCacheTtl().toMillis(), TimeUnit.MILLISECONDS);
        this.clientCache = SafeCaches.buildNonEvictableCache((CacheBuilder)cacheBuilder);
    }

    public BigQueryClient create(ConnectorSession session) {
        IdentityCacheMapping.IdentityCacheKey cacheKey = this.identityCacheMapping.getRemoteUserCacheKey(session);
        return (BigQueryClient)CacheUtils.uncheckedCacheGet(this.clientCache, (Object)cacheKey, () -> this.createBigQueryClient(session));
    }

    protected BigQueryClient createBigQueryClient(ConnectorSession session) {
        return new BigQueryClient(this.createBigQuery(session), this.labelFactory, this.typeManager, this.caseInsensitiveNameMatching, this.caseInsensitiveNameMatchingCacheTtl, this.materializationCache, this.metadataCacheTtl, this.projectId);
    }

    protected BigQuery createBigQuery(ConnectorSession session) {
        BigQueryOptions.Builder options = BigQueryOptions.newBuilder();
        for (BigQueryOptionsConfigurer configurer : this.optionsConfigurers) {
            options = configurer.configure(options, session);
        }
        return (BigQuery)options.build().getService();
    }
}

