/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import io.trino.plugin.base.logging.FormatInterpolator;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Objects;

public class BigQueryLabelFactory {
    private static final CharMatcher ALLOWED_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_-")).precomputed();
    private static final int MAX_LABEL_VALUE_LENGTH = 63;
    private final String name;
    private final FormatInterpolator<ConnectorSession> interpolator;

    public BigQueryLabelFactory(String labelName, FormatInterpolator<ConnectorSession> interpolator) {
        this.name = labelName;
        this.interpolator = Objects.requireNonNull(interpolator, "interpolator is null");
    }

    public Map<String, String> getLabels(ConnectorSession session) {
        if (Strings.isNullOrEmpty((String)this.name)) {
            return Map.of();
        }
        String value = this.interpolator.interpolate((Object)session).trim();
        if (Strings.isNullOrEmpty((String)value)) {
            return Map.of();
        }
        this.verifyLabelValue(this.name);
        this.verifyLabelValue(value);
        return Map.of(this.name, value);
    }

    private void verifyLabelValue(String value) {
        Verify.verify((value.length() <= 63 ? 1 : 0) != 0, (String)"BigQuery label value cannot be longer than %s characters", (int)63);
        Verify.verify((boolean)ALLOWED_CHARS.matchesAllOf((CharSequence)value), (String)"BigQuery label value can contain only lowercase letters, numeric characters, underscores, and dashes", (Object[])new Object[0]);
    }
}

