/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryArrowBufferAllocator;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryEmptyProjectionPageSource;
import io.trino.plugin.bigquery.BigQueryQueryPageSource;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQuerySplit;
import io.trino.plugin.bigquery.BigQueryStorageArrowPageSource;
import io.trino.plugin.bigquery.BigQueryStorageAvroPageSource;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.ForBigQueryPageSource;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class BigQueryPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Logger log = Logger.get(BigQueryPageSourceProvider.class);
    private final BigQueryClientFactory bigQueryClientFactory;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final BigQueryTypeManager typeManager;
    private final int maxReadRowsRetries;
    private final boolean arrowSerializationEnabled;
    private final ExecutorService executor;
    private final Optional<BigQueryArrowBufferAllocator> arrowBufferAllocator;

    @Inject
    public BigQueryPageSourceProvider(BigQueryClientFactory bigQueryClientFactory, BigQueryReadClientFactory bigQueryReadClientFactory, BigQueryTypeManager typeManager, BigQueryConfig config, Optional<BigQueryArrowBufferAllocator> arrowBufferAllocator, @ForBigQueryPageSource ExecutorService executor) {
        this.bigQueryClientFactory = Objects.requireNonNull(bigQueryClientFactory, "bigQueryClientFactory is null");
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxReadRowsRetries = config.getMaxReadRowsRetries();
        this.arrowSerializationEnabled = config.isArrowSerializationEnabled();
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.arrowBufferAllocator = Objects.requireNonNull(arrowBufferAllocator, "arrowBufferAllocator is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        log.debug("createPageSource(transaction=%s, session=%s, split=%s, table=%s, columns=%s)", new Object[]{transaction, session, split, table, columns});
        BigQuerySplit bigQuerySplit = (BigQuerySplit)split;
        Set projectedColumnNames = bigQuerySplit.columns().stream().map(BigQueryColumnHandle::name).collect(Collectors.toSet());
        columns.stream().map(BigQueryColumnHandle.class::cast).forEach(column -> Preconditions.checkArgument((boolean)projectedColumnNames.contains(column.name()), (Object)"projected columns should contain all reader columns"));
        if (bigQuerySplit.representsEmptyProjection()) {
            return new BigQueryEmptyProjectionPageSource(bigQuerySplit.emptyRowsToGenerate());
        }
        List bigQueryColumnHandles = (List)columns.stream().map(BigQueryColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return this.createPageSource(session, (BigQueryTableHandle)table, bigQuerySplit, bigQueryColumnHandles);
    }

    private ConnectorPageSource createPageSource(ConnectorSession session, BigQueryTableHandle table, BigQuerySplit split, List<BigQueryColumnHandle> columnHandles) {
        return switch (split.mode()) {
            default -> throw new MatchException(null, null);
            case BigQuerySplit.Mode.STORAGE -> this.createStoragePageSource(session, split, columnHandles);
            case BigQuerySplit.Mode.QUERY -> this.createQueryPageSource(session, table, columnHandles, split.filter());
        };
    }

    private ConnectorPageSource createStoragePageSource(ConnectorSession session, BigQuerySplit split, List<BigQueryColumnHandle> columnHandles) {
        if (this.arrowSerializationEnabled) {
            return new BigQueryStorageArrowPageSource(this.typeManager, this.bigQueryReadClientFactory.create(session), this.executor, this.arrowBufferAllocator.orElseThrow(() -> new IllegalStateException("ArrowBufferAllocator was not bound")), this.maxReadRowsRetries, split, columnHandles);
        }
        return new BigQueryStorageAvroPageSource(this.bigQueryReadClientFactory.create(session), this.executor, this.typeManager, this.maxReadRowsRetries, split, columnHandles);
    }

    private ConnectorPageSource createQueryPageSource(ConnectorSession session, BigQueryTableHandle table, List<BigQueryColumnHandle> columnHandles, Optional<String> filter) {
        return new BigQueryQueryPageSource(session, this.typeManager, this.bigQueryClientFactory.create(session), this.executor, table, columnHandles, filter);
    }
}

