/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.bigquery.BigQueryRelationHandle;
import io.trino.plugin.bigquery.RemoteTableName;
import java.util.Objects;

public class BigQueryQueryRelationHandle
extends BigQueryRelationHandle {
    private final String query;
    private final RemoteTableName destinationTableName;
    private final boolean useStorageApi;

    @JsonCreator
    public BigQueryQueryRelationHandle(String query, RemoteTableName destinationTableName, boolean useStorageApi) {
        this.query = query;
        this.destinationTableName = Objects.requireNonNull(destinationTableName, "destinationTableName is null");
        this.useStorageApi = useStorageApi;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public RemoteTableName getDestinationTableName() {
        return this.destinationTableName;
    }

    @Override
    @JsonProperty
    public boolean isUseStorageApi() {
        return this.useStorageApi;
    }

    @Override
    public String toString() {
        return String.format("Query[%s], Destination table[%s], Api[%s]", this.query, this.destinationTableName, this.useStorageApi ? "Storage" : "Rest");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQueryQueryRelationHandle that = (BigQueryQueryRelationHandle)o;
        return this.query.equals(that.query) && this.destinationTableName.equals(that.destinationTableName) && this.useStorageApi == that.useStorageApi;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.destinationTableName, this.useStorageApi);
    }
}

