/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.JobInfo;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public final class BigQuerySessionProperties
implements SessionPropertiesProvider {
    private static final String SKIP_VIEW_MATERIALIZATION = "skip_view_materialization";
    private static final String VIEW_MATERIALIZATION_WITH_FILTER = "view_materialization_with_filter";
    private static final String QUERY_RESULTS_CACHE_ENABLED = "query_results_cache_enabled";
    private static final String CREATE_DISPOSITION_TYPE = "create_disposition_type";
    private static final String PROJECTION_PUSHDOWN_ENABLED = "projection_pushdown_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public BigQuerySessionProperties(BigQueryConfig config) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)SKIP_VIEW_MATERIALIZATION, (String)"Skip materializing views", (Boolean)config.isSkipViewMaterialization(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)VIEW_MATERIALIZATION_WITH_FILTER, (String)"Materialize views with filters", (Boolean)config.isViewMaterializationWithFilter(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)QUERY_RESULTS_CACHE_ENABLED, (String)"Enable query results cache", (Boolean)config.isQueryResultsCacheEnabled(), (boolean)false)).add((Object)PropertyMetadata.enumProperty((String)CREATE_DISPOSITION_TYPE, (String)"Create disposition type", JobInfo.CreateDisposition.class, (Enum)JobInfo.CreateDisposition.CREATE_IF_NEEDED, (boolean)true)).add((Object)PropertyMetadata.booleanProperty((String)PROJECTION_PUSHDOWN_ENABLED, (String)"Dereference push down for STRUCT type", (Boolean)config.isProjectionPushdownEnabled(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isSkipViewMaterialization(ConnectorSession session) {
        return (Boolean)session.getProperty(SKIP_VIEW_MATERIALIZATION, Boolean.class);
    }

    public static boolean isViewMaterializationWithFilter(ConnectorSession session) {
        return (Boolean)session.getProperty(VIEW_MATERIALIZATION_WITH_FILTER, Boolean.class);
    }

    public static boolean isQueryResultsCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(QUERY_RESULTS_CACHE_ENABLED, Boolean.class);
    }

    public static JobInfo.CreateDisposition createDisposition(ConnectorSession session) {
        return (JobInfo.CreateDisposition)session.getProperty(CREATE_DISPOSITION_TYPE, JobInfo.CreateDisposition.class);
    }

    public static boolean isProjectionPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PROJECTION_PUSHDOWN_ENABLED, Boolean.class);
    }
}

