/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public record BigQuerySplit(Mode mode, String streamName, String schemaString, List<BigQueryColumnHandle> columns, long emptyRowsToGenerate, Optional<String> filter, OptionalInt dataSize) implements ConnectorSplit
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BigQuerySplit.class);
    private static final int NO_ROWS_TO_GENERATE = -1;

    public BigQuerySplit {
        Objects.requireNonNull(mode, "mode is null");
        Objects.requireNonNull(streamName, "streamName cannot be null");
        Objects.requireNonNull(schemaString, "schemaString cannot be null");
        columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns cannot be null"));
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(dataSize, "dataSize is null");
    }

    static BigQuerySplit forStream(String streamName, String schemaString, List<BigQueryColumnHandle> columns, OptionalInt dataSize) {
        return new BigQuerySplit(Mode.STORAGE, streamName, schemaString, columns, -1L, Optional.empty(), dataSize);
    }

    static BigQuerySplit forViewStream(List<BigQueryColumnHandle> columns, Optional<String> filter) {
        return new BigQuerySplit(Mode.QUERY, "", "", columns, -1L, filter, OptionalInt.empty());
    }

    static BigQuerySplit emptyProjection(long numberOfRows) {
        return new BigQuerySplit(Mode.STORAGE, "", "", (List<BigQueryColumnHandle>)ImmutableList.of(), numberOfRows, Optional.empty(), OptionalInt.of(0));
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.of((Object)"mode", (Object)this.mode.name(), (Object)"filter", (Object)this.filter.orElse(""), (Object)"streamName", (Object)this.streamName, (Object)"emptyRowsToGenerate", (Object)String.valueOf(this.emptyRowsToGenerate));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.streamName) + SizeOf.estimatedSizeOf((String)this.schemaString) + SizeOf.estimatedSizeOf(this.columns, BigQueryColumnHandle::getRetainedSizeInBytes);
    }

    boolean representsEmptyProjection() {
        return this.emptyRowsToGenerate != -1L;
    }

    public static enum Mode {
        STORAGE,
        QUERY;

    }
}

