/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQuerySplitSource;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import java.util.Objects;

public class BigQuerySplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(BigQuerySplitManager.class);
    private final BigQueryClientFactory bigQueryClientFactory;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final boolean viewEnabled;
    private final boolean arrowSerializationEnabled;
    private final Duration viewExpiration;
    private final NodeManager nodeManager;
    private final int maxReadRowsRetries;

    @Inject
    public BigQuerySplitManager(BigQueryConfig config, BigQueryClientFactory bigQueryClientFactory, BigQueryReadClientFactory bigQueryReadClientFactory, NodeManager nodeManager) {
        this.bigQueryClientFactory = Objects.requireNonNull(bigQueryClientFactory, "bigQueryClientFactory cannot be null");
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory cannot be null");
        this.viewEnabled = config.isViewsEnabled();
        this.arrowSerializationEnabled = config.isArrowSerializationEnabled();
        this.viewExpiration = config.getViewExpireDuration();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager cannot be null");
        this.maxReadRowsRetries = config.getMaxReadRowsRetries();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        log.debug("getSplits(transaction=%s, session=%s, table=%s)", new Object[]{transaction, session, table});
        return new BigQuerySplitSource(session, (BigQueryTableHandle)table, this.bigQueryClientFactory, this.bigQueryReadClientFactory, this.viewEnabled, this.arrowSerializationEnabled, this.viewExpiration, this.nodeManager, this.maxReadRowsRetries);
    }
}

