/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.bigquery.BigQueryArrowBufferAllocator;
import io.trino.plugin.bigquery.BigQueryArrowToPageConverter;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQuerySplit;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.ReadRowsHelper;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;

public class BigQueryStorageArrowPageSource
implements ConnectorPageSource {
    private static final Logger log = Logger.get(BigQueryStorageArrowPageSource.class);
    private final AtomicLong readBytes = new AtomicLong();
    private final AtomicLong readTimeNanos = new AtomicLong();
    private final BigQueryReadClient bigQueryReadClient;
    private final ExecutorService executor;
    private final String streamName;
    private final BigQueryArrowToPageConverter bigQueryArrowToPageConverter;
    private final BufferAllocator streamBufferAllocator;
    private final PageBuilder pageBuilder;
    private final Iterator<ReadRowsResponse> responses;
    private CompletableFuture<ReadRowsResponse> nextResponse;
    private boolean finished;

    public BigQueryStorageArrowPageSource(BigQueryTypeManager typeManager, BigQueryReadClient bigQueryReadClient, ExecutorService executor, BigQueryArrowBufferAllocator bufferAllocator, int maxReadRowsRetries, BigQuerySplit split, List<BigQueryColumnHandle> columns) {
        this.bigQueryReadClient = Objects.requireNonNull(bigQueryReadClient, "bigQueryReadClient is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(split, "split is null");
        this.streamName = split.streamName();
        Objects.requireNonNull(columns, "columns is null");
        Schema schema = BigQueryStorageArrowPageSource.deserializeSchema(split.schemaString());
        log.debug("Starting to read from %s", new Object[]{split.streamName()});
        this.responses = new ReadRowsHelper(bigQueryReadClient, split.streamName(), maxReadRowsRetries).readRows();
        this.nextResponse = CompletableFuture.supplyAsync(this::getResponse, executor);
        this.streamBufferAllocator = bufferAllocator.newChildAllocator(split);
        this.bigQueryArrowToPageConverter = new BigQueryArrowToPageConverter(typeManager, this.streamBufferAllocator, schema, columns);
        this.pageBuilder = new PageBuilder((List)columns.stream().map(BigQueryColumnHandle::trinoType).collect(ImmutableList.toImmutableList()));
    }

    public long getCompletedBytes() {
        return this.readBytes.get();
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos.get();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Page getNextPage() {
        ReadRowsResponse response;
        Preconditions.checkState((boolean)this.pageBuilder.isEmpty(), (Object)"PageBuilder is not empty at the beginning of a new page");
        try {
            response = (ReadRowsResponse)MoreFutures.getFutureValue(this.nextResponse);
        }
        catch (NoSuchElementException ignored) {
            this.finished = true;
            return null;
        }
        this.nextResponse = CompletableFuture.supplyAsync(this::getResponse, this.executor);
        long start = System.nanoTime();
        try (ArrowRecordBatch batch = this.deserializeResponse(this.streamBufferAllocator, response);){
            this.bigQueryArrowToPageConverter.convert(this.pageBuilder, batch);
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        this.readTimeNanos.addAndGet(System.nanoTime() - start);
        return page;
    }

    public long getMemoryUsage() {
        return this.streamBufferAllocator.getAllocatedMemory() + this.pageBuilder.getRetainedSizeInBytes();
    }

    public void close() {
        this.streamBufferAllocator.close();
        this.bigQueryArrowToPageConverter.close();
        this.nextResponse.cancel(true);
        this.bigQueryReadClient.close();
    }

    public CompletableFuture<?> isBlocked() {
        return this.nextResponse;
    }

    public Metrics getMetrics() {
        return new Metrics((Map)ImmutableMap.of((Object)"ArrowAllocatedMemory", (Object)new LongCount(this.streamBufferAllocator.getAllocatedMemory()), (Object)"ArrowPeakAllocatedMemory", (Object)new LongCount(this.streamBufferAllocator.getPeakMemoryAllocation())));
    }

    private ReadRowsResponse getResponse() {
        long start = System.nanoTime();
        ReadRowsResponse response = this.responses.next();
        this.readTimeNanos.addAndGet(System.nanoTime() - start);
        return response;
    }

    private ArrowRecordBatch deserializeResponse(BufferAllocator allocator, ReadRowsResponse response) {
        int serializedSize = response.getArrowRecordBatch().getSerializedSize();
        long totalReadSize = this.readBytes.addAndGet(serializedSize);
        log.debug("Read %d bytes (total %d) from %s", new Object[]{serializedSize, totalReadSize, this.streamName});
        try {
            return MessageSerializer.deserializeRecordBatch((ReadChannel)BigQueryStorageArrowPageSource.readChannelForByteString(response.getArrowRecordBatch().getSerializedRecordBatch()), (BufferAllocator)allocator);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error deserializing next Arrow Batch", e);
        }
    }

    private static ReadChannel readChannelForByteString(ByteString input) {
        return new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(input.toByteArray()));
    }

    private static Schema deserializeSchema(String schema) {
        try {
            return Schema.fromJSON((String)schema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

