/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.protobuf.ByteString;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class BigQueryTypeUtils {
    private static final long MIN_SUPPORTED_DATE = LocalDate.parse("0001-01-01").toEpochDay();
    private static final long MAX_SUPPORTED_DATE = LocalDate.parse("9999-12-31").toEpochDay();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");

    private BigQueryTypeUtils() {
    }

    @Nullable
    public static Object readNativeValue(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return BooleanType.BOOLEAN.getBoolean(block, position);
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return type.getLong(block, position);
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return SmallintType.SMALLINT.getLong(block, position);
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return IntegerType.INTEGER.getInt(block, position);
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return BigintType.BIGINT.getLong(block, position);
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return DoubleType.DOUBLE.getDouble(block, position);
        }
        if (type instanceof DecimalType) {
            return Decimals.readBigDecimal((DecimalType)((DecimalType)type), (Block)block, (int)position).toString();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return varcharType.getSlice(block, position).toStringUtf8();
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return ByteString.copyFrom((byte[])VarbinaryType.VARBINARY.getSlice(block, position).getBytes());
        }
        if (type.equals((Object)DateType.DATE)) {
            int days = DateType.DATE.getInt(block, position);
            if ((long)days < MIN_SUPPORTED_DATE || (long)days > MAX_SUPPORTED_DATE) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "BigQuery supports dates between 0001-01-01 and 9999-12-31 but got " + String.valueOf(LocalDate.ofEpochDay(days)));
            }
            return DATE_FORMATTER.format(LocalDate.ofEpochDay(days));
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MICROS)) {
            long epochMicros = TimestampType.TIMESTAMP_MICROS.getLong(block, position);
            return BigQueryTypeManager.datetimeToStringConverter(epochMicros);
        }
        if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
            LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.getObject(block, position);
            return BigQueryTypeManager.timestampToStringConverter(timestamp);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Block arrayBlock = arrayType.getObject(block, position);
            JSONArray list = new JSONArray();
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = BigQueryTypeUtils.readNativeValue(arrayType.getElementType(), arrayBlock, i);
                if (element == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "BigQuery does not support null elements in arrays");
                }
                list.put(element);
            }
            return list;
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            SqlRow sqlRow = rowType.getObject(block, position);
            List fieldTypes = rowType.getTypeParameters();
            if (fieldTypes.size() != sqlRow.getFieldCount()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected row value field count does not match type field count");
            }
            int rawIndex = sqlRow.getRawIndex();
            JSONObject rowValue = new JSONObject();
            for (int fieldIndex = 0; fieldIndex < sqlRow.getFieldCount(); ++fieldIndex) {
                String fieldName = (String)((RowType.Field)rowType.getFields().get(fieldIndex)).getName().orElseThrow(() -> new IllegalArgumentException("Field name must exist in BigQuery"));
                Object fieldValue = BigQueryTypeUtils.readNativeValue((Type)fieldTypes.get(fieldIndex), sqlRow.getRawFieldBlock(fieldIndex), rawIndex);
                rowValue.put(fieldName, fieldValue);
            }
            return rowValue;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(type));
    }
}

