/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryOptionsConfigurer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class BigQueryWriteClientFactory {
    private final Set<BigQueryOptionsConfigurer> configurers;

    @Inject
    public BigQueryWriteClientFactory(Set<BigQueryOptionsConfigurer> configurers) {
        this.configurers = ImmutableSet.copyOf((Collection)Objects.requireNonNull(configurers, "configurers is null"));
    }

    public BigQueryWriteClient create(ConnectorSession session) {
        BigQueryWriteSettings.Builder builder = BigQueryWriteSettings.newBuilder();
        for (BigQueryOptionsConfigurer configurer : this.configurers) {
            builder = configurer.configure(builder, session);
        }
        try {
            return BigQueryWriteClient.create((BigQueryWriteSettings)builder.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating BigQueryWriteClient", e);
        }
    }
}

