/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryGrpcOptionsConfigurer;
import io.trino.plugin.bigquery.BigQueryRpcConfig;
import io.trino.spi.connector.ConnectorSession;

public class GrpcChannelOptionsConfigurer
implements BigQueryGrpcOptionsConfigurer {
    private final ChannelPoolSettings channelPoolSettings;

    @Inject
    public GrpcChannelOptionsConfigurer(BigQueryRpcConfig rpcConfig) {
        this.channelPoolSettings = ChannelPoolSettings.builder().setInitialChannelCount(rpcConfig.getRpcInitialChannelCount()).setMinChannelCount(rpcConfig.getRpcMinChannelCount()).setMaxChannelCount(rpcConfig.getRpcMaxChannelCount()).setMinRpcsPerChannel(rpcConfig.getMinRpcPerChannel()).setMaxRpcsPerChannel(rpcConfig.getMaxRpcPerChannel()).build();
    }

    @Override
    public BigQueryOptions.Builder configure(BigQueryOptions.Builder builder, ConnectorSession session) {
        return builder;
    }

    @Override
    public InstantiatingGrpcChannelProvider.Builder configure(InstantiatingGrpcChannelProvider.Builder channelBuilder, ConnectorSession session) {
        return channelBuilder.setChannelPoolSettings(this.channelPoolSettings);
    }
}

