/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.storage.v1.TableName;
import java.util.Objects;

public record RemoteTableName(String projectId, String datasetName, String tableName) {
    public RemoteTableName {
        Objects.requireNonNull(projectId, "projectId is null");
        Objects.requireNonNull(datasetName, "datasetName is null");
        Objects.requireNonNull(tableName, "tableName is null");
    }

    public RemoteTableName(TableId tableId) {
        this(tableId.getProject(), tableId.getDataset(), tableId.getTable());
    }

    public TableId toTableId() {
        return TableId.of((String)this.projectId, (String)this.datasetName, (String)this.tableName);
    }

    public TableName toTableName() {
        return TableName.of((String)this.projectId, (String)this.datasetName, (String)this.tableName);
    }

    @Override
    public String toString() {
        return String.format("%s.%s.%s", this.projectId, this.datasetName, this.tableName);
    }
}

