/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.ProxyTransportFactory;
import io.trino.plugin.bigquery.StaticCredentialsConfig;
import io.trino.spi.connector.ConnectorSession;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;

public class StaticBigQueryCredentialsSupplier
implements BigQueryCredentialsSupplier {
    private final Supplier<Optional<Credentials>> credentialsCreator;

    @Inject
    public StaticBigQueryCredentialsSupplier(StaticCredentialsConfig config, Optional<ProxyTransportFactory> proxyTransportFactory) {
        Optional<HttpTransportFactory> httpTransportFactory = proxyTransportFactory.map(ProxyTransportFactory::getTransportOptions).map(HttpTransportOptions::getHttpTransportFactory);
        Optional<Credentials> credentialsKey = config.getCredentialsKey().map(key -> StaticBigQueryCredentialsSupplier.createCredentialsFromKey(httpTransportFactory, key));
        Optional<Credentials> credentialsFile = config.getCredentialsFile().map(keyFile -> StaticBigQueryCredentialsSupplier.createCredentialsFromFile(httpTransportFactory, keyFile));
        this.credentialsCreator = Suppliers.memoize(() -> credentialsKey.or(() -> credentialsFile));
    }

    @Override
    public Optional<Credentials> getCredentials(ConnectorSession session) {
        return (Optional)this.credentialsCreator.get();
    }

    private static Credentials createCredentialsFromKey(Optional<HttpTransportFactory> httpTransportFactory, String key) {
        return StaticBigQueryCredentialsSupplier.createCredentialsFromStream(httpTransportFactory, new ByteArrayInputStream(StaticBigQueryCredentialsSupplier.decodeBase64(key)));
    }

    private static Credentials createCredentialsFromFile(Optional<HttpTransportFactory> httpTransportFactory, String file) {
        try {
            return StaticBigQueryCredentialsSupplier.createCredentialsFromStream(httpTransportFactory, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException("Failed to create Credentials from file", e);
        }
    }

    private static Credentials createCredentialsFromStream(Optional<HttpTransportFactory> httpTransportFactory, InputStream inputStream) {
        try {
            if (httpTransportFactory.isPresent()) {
                return GoogleCredentials.fromStream((InputStream)inputStream, (HttpTransportFactory)httpTransportFactory.get());
            }
            return GoogleCredentials.fromStream((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from stream", e);
        }
    }

    private static byte[] decodeBase64(String base64String) {
        try {
            return BaseEncoding.base64().decode((CharSequence)base64String);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof BaseEncoding.DecodingException) {
                return BaseEncoding.base64Url().decode((CharSequence)base64String.trim());
            }
            throw e;
        }
    }
}

