/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery.procedure;

import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;

public final class ExecuteProcedure
implements Provider<Procedure> {
    private static final MethodHandle EXECUTE;
    private final BigQueryClientFactory clientFactory;

    @Inject
    public ExecuteProcedure(BigQueryClientFactory clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
    }

    public Procedure get() {
        return new Procedure("system", "execute", (List)ImmutableList.of((Object)new Procedure.Argument("QUERY", (Type)VarcharType.VARCHAR)), EXECUTE.bindTo(this));
    }

    public void execute(ConnectorSession session, String query) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            BigQueryClient client = this.clientFactory.create(session);
            client.executeUpdate(session, QueryJobConfiguration.of((String)query));
        }
    }

    static {
        try {
            EXECUTE = MethodHandles.lookup().unreflect(ExecuteProcedure.class.getMethod("execute", ConnectorSession.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

