/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryQueryRelationHandle;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.stream.Collectors;

public class Query
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "query";
    private final BigQueryClientFactory clientFactory;
    private final BigQueryTypeManager typeManager;

    @Inject
    public Query(BigQueryClientFactory clientFactory, BigQueryTypeManager typeManager) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorTableFunction get() {
        return new ClassLoaderSafeConnectorTableFunction((ConnectorTableFunction)new QueryFunction(this.clientFactory, this.typeManager), this.getClass().getClassLoader());
    }

    private static TableId buildDestinationTable(TableId remoteTableId) {
        String project = remoteTableId.getProject();
        String dataset = remoteTableId.getDataset();
        String name = String.format("%s%s", "_pbc_", UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", ""));
        return TableId.of((String)project, (String)dataset, (String)name);
    }

    public static class QueryFunction
    extends AbstractConnectorTableFunction {
        private final BigQueryClientFactory clientFactory;
        private final BigQueryTypeManager typeManager;

        public QueryFunction(BigQueryClientFactory clientFactory, BigQueryTypeManager typeManager) {
            super(Query.SCHEMA_NAME, Query.NAME, List.of(ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            ScalarArgument argument = (ScalarArgument)Iterables.getOnlyElement(arguments.values());
            String query = ((Slice)argument.getValue()).toStringUtf8();
            BigQueryClient client = this.clientFactory.create(session);
            TableId destinationTable = Query.buildDestinationTable(client.getDestinationTable(query));
            boolean useStorageApi = client.useStorageApi(query, destinationTable);
            Schema schema = client.getSchema(query);
            BigQueryQueryRelationHandle queryRelationHandle = new BigQueryQueryRelationHandle(query, new RemoteTableName(destinationTable), useStorageApi);
            BigQueryTableHandle tableHandle = new BigQueryTableHandle(queryRelationHandle, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), OptionalLong.empty());
            ImmutableList.Builder columnsBuilder = ImmutableList.builderWithExpectedSize((int)schema.getFields().size());
            for (Field field : schema.getFields()) {
                if (!this.typeManager.isSupportedType(field, useStorageApi)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(field.getType()));
                }
                columnsBuilder.add((Object)this.typeManager.toColumnHandle(field, useStorageApi));
            }
            Descriptor returnedType = new Descriptor(columnsBuilder.build().stream().map(column -> new Descriptor.Field(column.name(), Optional.of(column.trinoType()))).collect(Collectors.toList()));
            QueryHandle handle = new QueryHandle(tableHandle.withProjectedColumns((List<BigQueryColumnHandle>)columnsBuilder.build()));
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class QueryHandle
    implements ConnectorTableFunctionHandle {
        private final BigQueryTableHandle tableHandle;

        @JsonCreator
        public QueryHandle(@JsonProperty(value="tableHandle") BigQueryTableHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

