/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.MarshallerContext;

final class MarshallerMappingFileStore {
    private static final GridStripedLock fileLock = new GridStripedLock(32);
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    private final File mappingDir;

    MarshallerMappingFileStore(GridKernalContext kctx, File workDir) throws IgniteCheckedException {
        this.ctx = kctx;
        this.mappingDir = workDir;
        this.log = kctx.log(MarshallerMappingFileStore.class);
        this.fixLegacyFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMapping(byte platformId, int typeId, String typeName) {
        String fileName = BinaryUtils.mappingFileName(platformId, typeId);
        File tmpFile = new File(this.mappingDir, fileName + ThreadLocalRandom.current().nextInt() + ".tmp");
        File file = new File(this.mappingDir, fileName);
        Lock lock = MarshallerMappingFileStore.fileLock(fileName);
        lock.lock();
        try {
            try (FileOutputStream out = new FileOutputStream(tmpFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                writer.write(typeName);
                ((Writer)writer).flush();
            }
            Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            U.error(this.log, "Failed to write class name to file [platformId=" + platformId + ", id=" + typeId + ", clsName=" + typeName + ", file=" + file.getAbsolutePath() + ']', e);
        }
        finally {
            lock.unlock();
        }
    }

    public String readMapping(byte platformId, int typeId) {
        return this.readMapping(BinaryUtils.mappingFileName(platformId, typeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readMapping(String fileName) {
        Lock lock = MarshallerMappingFileStore.fileLock(fileName);
        lock.lock();
        try {
            String string = BinaryUtils.readMapping(new File(this.mappingDir, fileName));
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    void restoreMappings(MarshallerContext marshCtx) throws IgniteCheckedException {
        File[] files = this.mappingDir.listFiles(BinaryUtils::notTmpFile);
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = file.getName();
            byte platformId = BinaryUtils.mappedFilePlatformId(name);
            int typeId = this.getTypeId(name);
            String clsName = this.readMapping(name);
            if (clsName == null) {
                throw new IgniteCheckedException("Class name is null for [platformId=" + platformId + ", typeId=" + typeId + "], marshaller mappings storage is broken. Clean up marshaller directory (<work_dir>/marshaller) and restart the node. File name: " + name + ", FileSize: " + file.length());
            }
            marshCtx.registerClassNameLocally(platformId, typeId, clsName);
        }
    }

    void mergeAndWriteMapping(byte platformId, int typeId, String typeName) throws IgniteCheckedException {
        String existingTypeName = this.readMapping(platformId, typeId);
        if (existingTypeName != null) {
            if (!existingTypeName.equals(typeName)) {
                throw new IgniteCheckedException("Failed to merge new and existing marshaller mappings. For [platformId=" + platformId + ", typeId=" + typeId + "] new typeName=" + typeName + ", existing typeName=" + existingTypeName + ". Consider cleaning up persisted mappings from <workDir>/marshaller directory.");
            }
        } else {
            this.writeMapping(platformId, typeId, typeName);
        }
    }

    private void fixLegacyFolder() throws IgniteCheckedException {
        if (this.ctx.config().getWorkDirectory() == null) {
            return;
        }
        File legacyDir = new File(this.ctx.config().getWorkDirectory(), "marshaller");
        File legacyTmpDir = new File(legacyDir + ".tmp");
        if (legacyTmpDir.exists() && !IgniteUtils.delete(legacyTmpDir)) {
            throw new IgniteCheckedException("Failed to delete legacy marshaller mappings dir: " + legacyTmpDir.getAbsolutePath());
        }
        if (legacyDir.exists()) {
            try {
                IgniteUtils.copy(legacyDir, this.mappingDir, true);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to copy legacy marshaller mappings dir to new location", e);
            }
            try {
                Files.move(legacyDir.toPath(), legacyTmpDir.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to rename legacy marshaller mappings dir", e);
            }
            if (!IgniteUtils.delete(legacyTmpDir)) {
                throw new IgniteCheckedException("Failed to delete legacy marshaller mappings dir");
            }
        }
    }

    private int getTypeId(String fileName) throws IgniteCheckedException {
        int typeId;
        try {
            typeId = Integer.parseInt(fileName.substring(0, fileName.indexOf(".classname")));
        }
        catch (NumberFormatException e) {
            throw new IgniteCheckedException("Reading marshaller mapping from file " + fileName + " failed; type ID is expected to be numeric.", e);
        }
        return typeId;
    }

    private static Lock fileLock(String fileName) {
        return fileLock.getLock(fileName.hashCode());
    }
}

