/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCache;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandlerFactory;
import org.apache.ignite.internal.cache.query.index.sorted.MetaPageInfo;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.ThreadLocalRowHandlerHolder;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineObjectBytesDetector;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineRecommender;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineInnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineLeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccIO;
import org.apache.ignite.internal.cache.query.index.sorted.maintenance.MaintenanceRebuildIndexUtils;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandlerWrapper;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.jetbrains.annotations.Nullable;

public class InlineIndexTree
extends BPlusTree<IndexRow, IndexRow> {
    public static final int IGNITE_VARIABLE_TYPE_DEFAULT_INLINE_SIZE = 10;
    private final int inlineSize;
    private final InlineRecommender recommender;
    private final boolean created;
    private final SortedIndexDefinition def;
    private final InlineIndexRowHandler rowHnd;
    private final CacheGroupContext grpCtx;
    @Nullable
    private final IoStatisticsHolder stats;
    private final IgniteLogger log;
    @Nullable
    private final IndexRowCache idxRowCache;
    private final boolean mvccEnabled;
    public static final int IGNITE_MAX_INDEX_PAYLOAD_SIZE_DEFAULT = 64;

    public InlineIndexTree(SortedIndexDefinition def, CacheGroupContext grpCtx, String treeName, IgniteCacheOffheapManager offheap, ReuseList reuseList, PageMemory pageMemory, PageIoResolver pageIoResolver, long metaPageId, boolean initNew, int configuredInlineSize, int maxInlineSize, IndexKeyTypeSettings keyTypeSettings, @Nullable IndexRowCache idxRowCache, @Nullable IoStatisticsHolder stats, InlineIndexRowHandlerFactory rowHndFactory, InlineRecommender recommender) throws IgniteCheckedException {
        super(treeName, grpCtx.groupId(), grpCtx.name(), pageMemory, grpCtx.shared().wal(), (AtomicLong)offheap.globalRemoveId(), metaPageId, reuseList, (byte)2, grpCtx.shared().kernalContext().failure(), grpCtx.shared().diagnostic().pageLockTracker(), pageIoResolver, InlineIndexTree.wrapper(def));
        this.grpCtx = grpCtx;
        this.log = grpCtx.shared().kernalContext().config().getGridLogger();
        this.stats = stats;
        this.created = initNew;
        this.def = def;
        this.idxRowCache = idxRowCache;
        this.mvccEnabled = false;
        if (!initNew) {
            MetaPageInfo metaInfo = this.metaInfo();
            this.inlineSize = metaInfo.inlineSize();
            this.setIos(this.inlineSize, this.mvccEnabled);
            boolean inlineObjSupported = this.inlineObjectSupported(def, metaInfo, rowHndFactory);
            keyTypeSettings.inlineObjHash(metaInfo.inlineObjectHash()).inlineObjSupported(inlineObjSupported);
            this.rowHnd = rowHndFactory.create(def, keyTypeSettings);
            if (!metaInfo.flagsSupported()) {
                this.upgradeMetaPage(inlineObjSupported);
            }
        } else {
            this.rowHnd = rowHndFactory.create(def, keyTypeSettings);
            this.inlineSize = InlineIndexTree.computeInlineSize(def.idxName().fullName(), this.rowHnd.inlineIndexKeyTypes(), this.rowHnd.indexKeyDefinitions(), configuredInlineSize, maxInlineSize, this.log);
            this.setIos(this.inlineSize, this.mvccEnabled);
        }
        this.initTree(initNew, this.inlineSize);
        this.recommender = recommender;
    }

    private void setIos(int inlineSize, boolean mvccEnabled) {
        this.setIos(AbstractInlineInnerIO.versions(inlineSize, mvccEnabled), AbstractInlineLeafIO.versions(inlineSize, mvccEnabled));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inlineObjectSupported(SortedIndexDefinition def, MetaPageInfo metaInfo, InlineIndexRowHandlerFactory rowHndFactory) {
        boolean bl;
        if (metaInfo.flagsSupported()) {
            return metaInfo.inlineObjectSupported();
        }
        if (!InlineObjectBytesDetector.objectMayBeInlined(metaInfo.inlineSize(), def.indexKeyDefinitions().values())) return false;
        try {
            InlineObjectBytesDetector inlineObjDetector = new InlineObjectBytesDetector(metaInfo.inlineSize(), def.indexKeyDefinitions().values(), def.idxName(), this.log);
            IndexKeyTypeSettings keyTypeSettings = new IndexKeyTypeSettings().inlineObjSupported(true).inlineObjHash(false);
            InlineIndexRowHandler rowHnd = rowHndFactory.create(def, keyTypeSettings);
            ThreadLocalRowHandlerHolder.rowHandler(rowHnd);
            this.findFirst(inlineObjDetector);
            bl = inlineObjDetector.inlineObjectSupported();
        }
        catch (Throwable throwable) {
            try {
                ThreadLocalRowHandlerHolder.clearRowHandler();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Unexpected exception on detect inline object", e);
            }
        }
        ThreadLocalRowHandlerHolder.clearRowHandler();
        return bl;
    }

    @Override
    protected int compare(BPlusIO<IndexRow> io, long pageAddr, int idx, IndexRow row) throws IgniteCheckedException {
        int keyIdx;
        if (this.inlineSize == 0) {
            IndexRow currRow = (IndexRow)this.getRow(io, pageAddr, idx);
            int cmp = this.compareFullRows(currRow, row, 0);
            return cmp == 0 ? this.mvccCompare(currRow, row) : cmp;
        }
        int fieldOff = 0;
        IndexRow currRow = null;
        int off = io.offset(idx);
        List<IndexKeyDefinition> keyDefs = this.rowHnd.indexKeyDefinitions();
        List<InlineIndexKeyType> keyTypes = this.rowHnd.inlineIndexKeyTypes();
        for (keyIdx = 0; keyIdx < keyTypes.size(); ++keyIdx) {
            try {
                if (row.key(keyIdx) == null) {
                    return 0;
                }
                int maxSize = this.inlineSize - fieldOff;
                InlineIndexKeyType keyType = keyTypes.get(keyIdx);
                int cmp = this.def.rowComparator().compareKey(pageAddr, off + fieldOff, maxSize, row.key(keyIdx), keyType);
                if (cmp == -2 || cmp == Integer.MIN_VALUE) break;
                fieldOff += keyType.inlineSize(pageAddr, off + fieldOff);
                if (cmp == 0) continue;
                IndexKeyDefinition keyDef = keyDefs.get(keyIdx);
                return InlineIndexTree.applySortOrder(cmp, keyDef.order().sortOrder());
            }
            catch (Exception e) {
                throw new IgniteException("Failed to store new index row.", e);
            }
        }
        if (keyIdx < keyDefs.size()) {
            int ret;
            this.recommender.recommend(row, this.inlineSize);
            if (currRow == null) {
                currRow = (IndexRow)this.getRow(io, pageAddr, idx);
            }
            if ((ret = this.compareFullRows(currRow, row, keyIdx)) != 0) {
                return ret;
            }
        }
        return this.mvccCompare((MvccIO)((Object)io), pageAddr, idx, row);
    }

    private int compareFullRows(IndexRow currRow, IndexRow row, int from) throws IgniteCheckedException {
        if (currRow == row) {
            return 0;
        }
        for (int i = from; i < this.rowHandler().indexKeyDefinitions().size(); ++i) {
            if (row.key(i) == null) {
                return 0;
            }
            int c = this.def.rowComparator().compareRow(currRow, row, i);
            if (c == 0) continue;
            return InlineIndexTree.applySortOrder(Integer.signum(c), this.rowHnd.indexKeyDefinitions().get(i).order().sortOrder());
        }
        return 0;
    }

    private static int applySortOrder(int c, SortOrder order) {
        return order == SortOrder.ASC ? c : -c;
    }

    public IndexRowImpl createIndexRow(long link) throws IgniteCheckedException {
        IndexRowImpl cachedRow;
        IndexRowImpl indexRowImpl = cachedRow = this.idxRowCache == null ? null : this.idxRowCache.get(link);
        if (cachedRow != null) {
            return cachedRow.rowHandler() == this.rowHandler() ? cachedRow : new IndexRowImpl(this.rowHandler(), cachedRow.cacheDataRow());
        }
        CacheDataRowAdapter row = new CacheDataRowAdapter(link);
        row.initFromLink(this.cacheGroupContext(), CacheDataRowAdapter.RowData.FULL, true);
        IndexRowImpl r = new IndexRowImpl(this.rowHandler(), row);
        if (this.idxRowCache != null) {
            this.idxRowCache.put(r);
        }
        return r;
    }

    public IndexRowImpl createMvccIndexRow(long link, long mvccCrdVer, long mvccCntr, int mvccOpCntr) throws IgniteCheckedException {
        IndexRowImpl cachedRow;
        IndexRowImpl indexRowImpl = cachedRow = this.idxRowCache == null ? null : this.idxRowCache.get(link);
        if (cachedRow != null) {
            return cachedRow;
        }
        int partId = PageIdUtils.partId(PageIdUtils.pageId(link));
        MvccDataRow row = new MvccDataRow(this.cacheGroupContext(), 0, link, partId, null, mvccCrdVer, mvccCntr, mvccOpCntr, true);
        IndexRowImpl r = new IndexRowImpl(this.rowHandler(), row);
        if (this.idxRowCache != null) {
            this.idxRowCache.put(r);
        }
        return r;
    }

    @Override
    public IndexRow getRow(BPlusIO<IndexRow> io, long pageAddr, int idx, Object ignore) throws IgniteCheckedException {
        return io.getLookupRow(this, pageAddr, idx);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    public static int computeInlineSize(String name, List<InlineIndexKeyType> keyTypes, List<IndexKeyDefinition> keyDefs, int cfgInlineSize, int maxInlineSize, IgniteLogger log) {
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(keyTypes)) {
            return 0;
        }
        boolean fixedSize = true;
        int propSize = maxInlineSize == -1 ? IgniteSystemProperties.getInteger("IGNITE_MAX_INDEX_PAYLOAD_SIZE", 64) : maxInlineSize;
        int size = 0;
        for (int i = 0; i < keyTypes.size(); ++i) {
            InlineIndexKeyType keyType = keyTypes.get(i);
            fixedSize &= keyType.keySize() != -1;
            int sizeInc = keyType.inlineSize();
            if (sizeInc < 0) {
                int precision = keyDefs.get(i).precision();
                sizeInc = precision > 0 ? 3 + precision : 10;
            }
            if ((size += sizeInc) <= propSize) continue;
            size = propSize;
            break;
        }
        if (cfgInlineSize != -1) {
            cfgInlineSize = Math.min(2048, cfgInlineSize);
            if (fixedSize && size < cfgInlineSize) {
                log.warning("Explicit INLINE_SIZE for fixed size index item is too big. This will lead to wasting of space inside index pages. Ignoring [index=" + name + ", explicitInlineSize=" + cfgInlineSize + ", realInlineSize=" + size + ']');
                return size;
            }
            return cfgInlineSize;
        }
        return Math.min(2048, size);
    }

    public CacheGroupContext cacheGroupContext() {
        return this.grpCtx;
    }

    public MetaPageInfo metaInfo() throws IgniteCheckedException {
        return MetaPageInfo.read(this.metaPageId, this.grpId, this.pageMem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeMetaPage(boolean inlineObjSupported) throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            long pageAddr = this.writeLock(this.metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to write lock meta page [metaPageId=" + U.hexLong(this.metaPageId) + ']';
            try {
                BPlusMetaIO.upgradePageVersion(pageAddr, inlineObjSupported, false, this.pageSize());
            }
            finally {
                this.writeUnlock(this.metaPageId, metaPage, pageAddr, Boolean.TRUE, true);
            }
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    public void copyMetaInfo(MetaPageInfo info) throws IgniteCheckedException {
        info.write(this.metaPageId, this.grpId, this.pageMem);
    }

    public boolean created() {
        return this.created;
    }

    @Override
    protected CorruptedTreeException corruptedTreeException(String msg, Throwable cause, int grpId, long ... pageIds) {
        IndexName idx = this.def.idxName();
        String indexName = idx.idxName();
        String cacheName = idx.cacheName();
        String tableName = idx.tableName();
        CorruptedTreeException e = new CorruptedTreeException(msg, cause, this.grpName, cacheName, indexName, grpId, pageIds);
        String errorMsg = "Index " + idx + " of the table " + tableName + " (cache " + cacheName + ") is corrupted, to fix this issue a rebuild is required. On the next restart, node will enter the maintenance mode and rebuild corrupted indexes.";
        this.log.warning(errorMsg);
        int cacheId = CU.cacheId(cacheName);
        try {
            MaintenanceTask task = MaintenanceRebuildIndexUtils.toMaintenanceTask(cacheId, indexName);
            this.grpCtx.shared().kernalContext().maintenanceRegistry().registerMaintenanceTask(task, oldTask -> MaintenanceRebuildIndexUtils.mergeTasks(oldTask, task));
        }
        catch (IgniteCheckedException ex) {
            this.log.warning("Failed to register maintenance record for corrupted partition files.", ex);
        }
        this.processFailure(FailureType.CRITICAL_ERROR, e);
        return e;
    }

    @Override
    protected void temporaryReleaseLock() {
        this.grpCtx.shared().database().checkpointReadUnlock();
        this.grpCtx.shared().database().checkpointReadLock();
    }

    @Override
    protected long maxLockHoldTime() {
        long sysWorkerBlockedTimeout = this.grpCtx.shared().kernalContext().workersRegistry().getSystemWorkerBlockedTimeout();
        return sysWorkerBlockedTimeout == 0L ? Long.MAX_VALUE : sysWorkerBlockedTimeout / 10L;
    }

    @Override
    protected IoStatisticsHolder statisticsHolder() {
        return this.stats != null ? this.stats : super.statisticsHolder();
    }

    @Override
    public String toString() {
        return S.toString(InlineIndexTree.class, this, "super", (Object)super.toString());
    }

    public InlineIndexRowHandler rowHandler() {
        return this.rowHnd != null ? this.rowHnd : ThreadLocalRowHandlerHolder.rowHandler();
    }

    private int mvccCompare(MvccIO io, long pageAddr, int idx, IndexRow row) {
        if (!this.mvccEnabled || row.indexPlainRow()) {
            return 0;
        }
        long crd = io.mvccCoordinatorVersion(pageAddr, idx);
        long cntr = io.mvccCounter(pageAddr, idx);
        int opCntr = io.mvccOperationCounter(pageAddr, idx);
        assert (MvccUtils.mvccVersionIsValid(crd, cntr, opCntr));
        return -MvccUtils.compare(crd, cntr, opCntr, row);
    }

    private int mvccCompare(IndexRow r1, IndexRow r2) {
        long crdVer2;
        if (!this.mvccEnabled || r2.indexPlainRow() || r1 == r2) {
            return 0;
        }
        long crdVer1 = r1.mvccCoordinatorVersion();
        int c = -Long.compare(crdVer1, crdVer2 = r2.mvccCoordinatorVersion());
        if (c != 0) {
            return c;
        }
        return -Long.compare(r1.mvccCounter(), r2.mvccCounter());
    }

    @Override
    protected String lockRetryErrorMessage(String op) {
        IndexName idxName = this.def.idxName();
        return super.lockRetryErrorMessage(op) + " Problem with the index [cacheName=" + idxName.cacheName() + ", schemaName=" + idxName.schemaName() + ", tblName=" + idxName.tableName() + ", idxName=" + idxName.idxName() + ']';
    }

    private static PageHandlerWrapper<BPlusTree.Result> wrapper(final SortedIndexDefinition def) {
        if (def == null || def.cacheInfo().cacheContext() == null) {
            return null;
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_BPLUS_TREE_DISABLE_METRICS")) {
            return null;
        }
        return new PageHandlerWrapper<BPlusTree.Result>(){

            @Override
            public PageHandler<?, BPlusTree.Result> wrap(BPlusTree<?, ?> tree, final PageHandler<?, BPlusTree.Result> hnd) {
                final GridCacheContext<?, ?> cctx = def.cacheInfo().cacheContext();
                MetricRegistry mreg = cctx.shared().kernalContext().metric().registry(MetricUtils.metricName("index", def.idxName().fullName()));
                final LongAdderMetric cnt = mreg.longAdderMetric(hnd.getClass().getSimpleName() + "Count", "Count of " + hnd.getClass().getSimpleName() + " operations");
                final LongAdderMetric time = mreg.longAdderMetric(hnd.getClass().getSimpleName() + "Time", "Total time of " + hnd.getClass().getSimpleName() + " operations (nanoseconds)");
                return new PageHandler<Object, BPlusTree.Result>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public BPlusTree.Result run(int cacheId, long pageId, long page, long pageAddr, PageIO io, Boolean walPlc, Object arg, int intArg, IoStatisticsHolder statHolder) throws IgniteCheckedException {
                        if (!cctx.statisticsEnabled()) {
                            return (BPlusTree.Result)((Object)hnd.run(cacheId, pageId, page, pageAddr, io, walPlc, arg, intArg, statHolder));
                        }
                        long ts = System.nanoTime();
                        try {
                            BPlusTree.Result result = (BPlusTree.Result)((Object)hnd.run(cacheId, pageId, page, pageAddr, io, walPlc, arg, intArg, statHolder));
                            return result;
                        }
                        finally {
                            cnt.increment();
                            time.add(System.nanoTime() - ts);
                        }
                    }

                    @Override
                    public boolean releaseAfterWrite(int cacheId, long pageId, long page, long pageAddr, Object arg, int intArg) {
                        return hnd.releaseAfterWrite(cacheId, pageId, page, pageAddr, arg, intArg);
                    }
                };
            }
        };
    }
}

