/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.jdbc.thin.JdbcThinParameterMetadata;
import org.apache.ignite.internal.jdbc2.JdbcConnection;
import org.apache.ignite.internal.jdbc2.JdbcResultSetMetadata;
import org.apache.ignite.internal.jdbc2.JdbcStatement;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.jetbrains.annotations.Nullable;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private final String sql;
    private List<List<Object>> batchArgs;
    private ParameterMetaData paramsMeta;
    private ResultSetMetaData resMeta;
    private boolean resMetaFetched;

    JdbcPreparedStatement(JdbcConnection conn, String sql) {
        super(conn);
        this.sql = sql;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Adding new SQL command to batch is not supported for prepared statement (use addBatch() to add new set of arguments)");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureNotClosed();
        return this.executeQuery(this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.ensureNotClosed();
        return this.executeUpdate(this.sql);
    }

    @Override
    public void setNull(int paramIdx, int sqlType) throws SQLException {
        this.setArgument(paramIdx, null);
    }

    @Override
    public void setBoolean(int paramIdx, boolean x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setByte(int paramIdx, byte x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setShort(int paramIdx, short x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setInt(int paramIdx, int x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setLong(int paramIdx, long x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setFloat(int paramIdx, float x) throws SQLException {
        this.setArgument(paramIdx, Float.valueOf(x));
    }

    @Override
    public void setDouble(int paramIdx, double x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setBigDecimal(int paramIdx, BigDecimal x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setString(int paramIdx, String x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setBytes(int paramIdx, byte[] x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setDate(int paramIdx, Date x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTime(int paramIdx, Time x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setUnicodeStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureNotClosed();
        this.args = null;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batchArgs = null;
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setObject(int paramIdx, Object x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.sql);
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureNotClosed();
        if (this.batchArgs == null) {
            this.batchArgs = new ArrayList<List<Object>>();
        }
        this.batchArgs.add(this.args);
        this.args = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        List<List<Object>> batchArgs = this.batchArgs;
        this.batchArgs = null;
        return this.doBatchUpdate(this.sql, null, batchArgs);
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setRef(int paramIdx, Ref x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, Blob x) throws SQLException {
        this.setBytes(paramIdx, x.getBytes(1L, (int)x.length()));
    }

    @Override
    public void setClob(int paramIdx, Clob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setArray(int paramIdx, Array x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        if (!this.resMetaFetched) {
            assert (this.resMeta == null);
            this.resMeta = this.getMetadata0();
            this.resMetaFetched = true;
        }
        return this.resMeta;
    }

    @Nullable
    private ResultSetMetaData getMetadata0() throws SQLException {
        SqlFieldsQuery qry = new SqlFieldsQuery(this.sql);
        this.setupQuery(qry);
        try {
            List<GridQueryFieldMetadata> meta = this.conn.ignite().context().query().resultSetMetaData(qry, null);
            if (meta == null) {
                return null;
            }
            return new JdbcResultSetMetadata(meta);
        }
        catch (IgniteSQLException ex) {
            throw ex.toJdbcException();
        }
    }

    @Override
    public void setDate(int paramIdx, Date x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTime(int paramIdx, Time x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setNull(int paramIdx, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIdx, sqlType);
    }

    @Override
    public void setURL(int paramIdx, URL x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.ensureNotClosed();
        if (this.paramsMeta == null) {
            this.paramsMeta = this.parameterMetaData();
        }
        return this.paramsMeta;
    }

    private ParameterMetaData parameterMetaData() throws SQLException {
        SqlFieldsQueryEx qry = new SqlFieldsQueryEx(this.sql, null);
        this.setupQuery(qry);
        try {
            List<JdbcParameterMeta> params = this.conn.ignite().context().query().parameterMetaData(qry, null);
            return new JdbcThinParameterMetadata(params);
        }
        catch (IgniteSQLException ex) {
            throw ex.toJdbcException();
        }
    }

    @Override
    public void setRowId(int paramIdx, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNString(int paramIdx, String val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setSQLXML(int paramIdx, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType, int scaleOrLen) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    private void setArgument(int paramIdx, Object val) throws SQLException {
        this.ensureNotClosed();
        if (paramIdx < 1) {
            throw new SQLException("Parameter index is invalid: " + paramIdx);
        }
        this.ensureArgsSize(paramIdx);
        this.args.set(paramIdx - 1, val);
    }

    private void ensureArgsSize(int size) {
        if (this.args == null) {
            this.args = new ArrayList(size);
        }
        this.args.ensureCapacity(size);
        while (this.args.size() < size) {
            this.args.add(null);
        }
    }
}

