/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.defragmentation;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.defragmentation.DefragmentationCommand;
import org.apache.ignite.internal.management.defragmentation.DefragmentationScheduleCommandArg;
import org.apache.ignite.internal.management.defragmentation.DefragmentationTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.IgniteDefragmentation;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class DefragmentationTask
extends VisorMultiNodeTask<DefragmentationCommand.DefragmentationStatusCommandArg, DefragmentationTaskResult, DefragmentationTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<DefragmentationCommand.DefragmentationStatusCommandArg, DefragmentationTaskResult> job(DefragmentationCommand.DefragmentationStatusCommandArg arg) {
        return new DefragmentationJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected DefragmentationTaskResult reduce0(List<ComputeJobResult> results) {
        if (this.taskArg instanceof DefragmentationScheduleCommandArg) {
            StringBuilder msg = new StringBuilder();
            for (ComputeJobResult res : results) {
                msg.append(res.getNode().consistentId()).append(":\n");
                if (res.getData() == null) {
                    msg.append("    err=").append(res.getException()).append('\n');
                    continue;
                }
                DefragmentationTaskResult data = (DefragmentationTaskResult)res.getData();
                msg.append("    success=").append(data.isSuccess()).append('\n');
                msg.append("    msg=").append(data.getMessage()).append('\n');
            }
            return new DefragmentationTaskResult(true, msg.toString());
        }
        assert (results.size() == 1);
        ComputeJobResult res = results.get(0);
        if (res.getException() == null) {
            return (DefragmentationTaskResult)res.getData();
        }
        throw res.getException();
    }

    private static class DefragmentationJob
    extends VisorJob<DefragmentationCommand.DefragmentationStatusCommandArg, DefragmentationTaskResult> {
        private static final long serialVersionUID = 0L;

        protected DefragmentationJob(@Nullable DefragmentationCommand.DefragmentationStatusCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected DefragmentationTaskResult run(@Nullable DefragmentationCommand.DefragmentationStatusCommandArg arg) throws IgniteException {
            if (arg instanceof DefragmentationScheduleCommandArg) {
                return this.runSchedule((DefragmentationScheduleCommandArg)arg);
            }
            if (arg instanceof DefragmentationCommand.DefragmentationCancelCommandArg) {
                return this.runCancel();
            }
            if (arg instanceof DefragmentationCommand.DefragmentationStatusCommandArg) {
                return this.runStatus();
            }
            throw new IllegalArgumentException("Operation: " + arg);
        }

        private DefragmentationTaskResult runSchedule(DefragmentationScheduleCommandArg arg) {
            String message;
            IgniteDefragmentation.ScheduleResult scheduleResult;
            IgniteDefragmentation defragmentation = this.ignite.context().defragmentation();
            try {
                scheduleResult = defragmentation.schedule(F.isEmpty(arg.caches()) ? null : Arrays.asList(arg.caches()));
            }
            catch (IgniteCheckedException e) {
                return new DefragmentationTaskResult(false, e.getMessage());
            }
            switch (scheduleResult) {
                case SUCCESS_SUPERSEDED_PREVIOUS: {
                    message = "Scheduling completed successfully. Previously scheduled task has been removed.";
                    break;
                }
                default: {
                    message = "Scheduling completed successfully.";
                }
            }
            return new DefragmentationTaskResult(true, message);
        }

        private DefragmentationTaskResult runStatus() {
            IgniteDefragmentation defragmentation = this.ignite.context().defragmentation();
            try {
                return new DefragmentationTaskResult(true, defragmentation.status().toString());
            }
            catch (IgniteCheckedException e) {
                return new DefragmentationTaskResult(false, e.getMessage());
            }
        }

        private DefragmentationTaskResult runCancel() {
            IgniteDefragmentation defragmentation = this.ignite.context().defragmentation();
            try {
                String message;
                IgniteDefragmentation.CancelResult cancelResult = defragmentation.cancel();
                switch (cancelResult) {
                    case SCHEDULED_NOT_FOUND: {
                        message = "Scheduled defragmentation task is not found.";
                        break;
                    }
                    case CANCELLED: {
                        message = "Defragmentation cancelled successfully.";
                        break;
                    }
                    case COMPLETED_OR_CANCELLED: {
                        message = "Defragmentation is already completed or has been cancelled previously.";
                        break;
                    }
                    default: {
                        message = "Scheduled defragmentation task cancelled successfully.";
                    }
                }
                return new DefragmentationTaskResult(true, message);
            }
            catch (IgniteCheckedException e) {
                return new DefragmentationTaskResult(false, e.getMessage());
            }
        }
    }
}

