/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionTaskResult;
import org.apache.ignite.internal.management.encryption.EncryptionReencryptionRateLimitCommandArg;
import org.apache.ignite.internal.management.encryption.ReencryptionRateTask;

public class EncryptionReencryptionRateLimitCommand
implements ComputeCommand<EncryptionReencryptionRateLimitCommandArg, CacheGroupEncryptionTaskResult<Double>> {
    @Override
    public String description() {
        return "View/change re-encryption rate limit";
    }

    @Override
    public Class<EncryptionReencryptionRateLimitCommandArg> argClass() {
        return EncryptionReencryptionRateLimitCommandArg.class;
    }

    @Override
    public Class<ReencryptionRateTask> taskClass() {
        return ReencryptionRateTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, EncryptionReencryptionRateLimitCommandArg arg) {
        return nodes;
    }

    @Override
    public void printResult(EncryptionReencryptionRateLimitCommandArg arg, CacheGroupEncryptionTaskResult<Double> res, Consumer<String> printer) {
        Map<UUID, IgniteException> exceptions = res.exceptions();
        for (Map.Entry<UUID, IgniteException> entry : exceptions.entrySet()) {
            printer.accept("  Node " + entry.getKey() + ":");
            printer.accept("    failed to get/set re-encryption rate limit: " + entry.getValue().getMessage());
        }
        Map<UUID, Double> results = res.results();
        boolean read = arg.newLimit() == null;
        for (Map.Entry<UUID, Double> entry : results.entrySet()) {
            Double rateLimit;
            printer.accept("  Node " + entry.getKey() + ":");
            Double d = rateLimit = read ? entry.getValue() : arg.newLimit();
            if (rateLimit == 0.0) {
                printer.accept("    re-encryption rate is not limited.");
                continue;
            }
            printer.accept(String.format("%sre-encryption rate %s limited to %.2f MB/s.", "    ", read ? "is" : "has been", rateLimit));
        }
        if (read) {
            return;
        }
        printer.accept("");
        printer.accept("Note: the changed value of the re-encryption rate limit is not persisted. When the node is restarted, the value will be set from the configuration.");
        printer.accept("");
    }
}

