/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearGetRequest
extends GridCacheIdMessage
implements GridCacheDeployable,
GridCacheVersionable {
    private static final long serialVersionUID = 0L;
    private static final int READ_THROUGH_FLAG_MASK = 1;
    private static final int SKIP_VALS_FLAG_MASK = 2;
    private static final int ADD_READER_FLAG_MASK = 4;
    public static final int RECOVERY_FLAG_MASK = 8;
    private IgniteUuid futId;
    private IgniteUuid miniId;
    private GridCacheVersion ver;
    @GridToStringInclude
    @GridDirectTransient
    private LinkedHashMap<KeyCacheObject, Boolean> keyMap;
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridDirectCollection(value=boolean.class)
    private List<Boolean> readersFlags;
    private byte flags;
    private AffinityTopologyVersion topVer;
    private int taskNameHash;
    private long createTtl;
    private long accessTtl;
    @Nullable
    private String txLbl;
    private MvccSnapshot mvccSnapshot;

    public GridNearGetRequest() {
    }

    public GridNearGetRequest(int cacheId, IgniteUuid futId, IgniteUuid miniId, GridCacheVersion ver, Map<KeyCacheObject, Boolean> keys, boolean readThrough, @NotNull AffinityTopologyVersion topVer, int taskNameHash, long createTtl, long accessTtl, boolean addReader, boolean skipVals, boolean addDepInfo, boolean recovery, @Nullable String txLbl, @Nullable MvccSnapshot mvccSnapshot) {
        assert (futId != null);
        assert (miniId != null);
        assert (keys != null);
        this.cacheId = cacheId;
        this.futId = futId;
        this.miniId = miniId;
        this.ver = ver;
        this.keys = new ArrayList<KeyCacheObject>(keys.size());
        if (addReader) {
            this.readersFlags = new ArrayList<Boolean>(keys.size());
        }
        for (Map.Entry<KeyCacheObject, Boolean> entry : keys.entrySet()) {
            this.keys.add(entry.getKey());
            if (!addReader) continue;
            this.readersFlags.add(entry.getValue());
        }
        this.topVer = topVer;
        this.taskNameHash = taskNameHash;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.addDepInfo = addDepInfo;
        this.txLbl = txLbl;
        this.mvccSnapshot = mvccSnapshot;
        if (readThrough) {
            this.flags = (byte)(this.flags | 1);
        }
        if (skipVals) {
            this.flags = (byte)(this.flags | 2);
        }
        if (addReader) {
            this.flags = (byte)(this.flags | 4);
        }
        if (recovery) {
            this.flags = (byte)(this.flags | 8);
        }
    }

    @Nullable
    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public GridCacheVersion version() {
        return this.ver;
    }

    public LinkedHashMap<KeyCacheObject, Boolean> keys() {
        return this.keyMap;
    }

    public boolean readThrough() {
        return (this.flags & 1) != 0;
    }

    public boolean skipValues() {
        return (this.flags & 2) != 0;
    }

    public boolean recovery() {
        return (this.flags & 8) != 0;
    }

    public boolean addReaders() {
        return (this.flags & 4) != 0;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public long createTtl() {
        return this.createTtl;
    }

    public long accessTtl() {
        return this.accessTtl;
    }

    @Override
    public int partition() {
        return this.keys != null && !this.keys.isEmpty() ? this.keys.get(0).partition() : -1;
    }

    @Nullable
    public String txLabel() {
        return this.txLbl;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        assert (ctx != null);
        assert (!F.isEmpty(this.keys));
        assert (this.readersFlags == null || this.keys.size() == this.readersFlags.size());
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObjects(this.keys, cctx);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.keys, cctx, ldr);
        assert (!F.isEmpty(this.keys));
        assert (this.readersFlags == null || this.keys.size() == this.readersFlags.size());
        if (this.keyMap == null) {
            this.keyMap = U.newLinkedHashMap(this.keys.size());
            Iterator<KeyCacheObject> keysIt = this.keys.iterator();
            for (int i = 0; i < this.keys.size(); ++i) {
                Boolean addRdr = this.readersFlags != null ? this.readersFlags.get(i) : Boolean.FALSE;
                this.keyMap.put(keysIt.next(), addRdr);
            }
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeLong("accessTtl", this.accessTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("createTtl", this.createTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeCollection("readersFlags", this.readersFlags, MessageCollectionItemType.BOOLEAN)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeString("txLbl", this.txLbl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeMessage("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.accessTtl = reader.readLong("accessTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.createTtl = reader.readLong("createTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.readersFlags = (List)reader.readCollection("readersFlags", MessageCollectionItemType.BOOLEAN);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.txLbl = reader.readString("txLbl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearGetRequest.class);
    }

    @Override
    public short directType() {
        return 49;
    }

    @Override
    public byte fieldsCount() {
        return 16;
    }

    @Override
    public String toString() {
        return S.toString(GridNearGetRequest.class, this);
    }
}

