/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.lang.IgniteInClosure;

public final class MvccDataLeafIO
extends AbstractDataLeafIO {
    public static final IOVersions<MvccDataLeafIO> VERSIONS = new IOVersions((PageIO[])new MvccDataLeafIO[]{new MvccDataLeafIO(1)});

    private MvccDataLeafIO(int ver) {
        super(25, ver, 48);
    }

    @Override
    public void visit(long pageAddr, IgniteInClosure<CacheSearchRow> c) {
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        for (int i = 0; i < cnt; ++i) {
            c.apply(new MvccDataRow(this.getLink(pageAddr, i)));
        }
    }

    @Override
    protected boolean storeMvccVersion() {
        return true;
    }

    @Override
    public long getMvccCoordinatorVersion(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 12);
    }

    @Override
    public long getMvccCounter(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 20);
    }

    @Override
    public int getMvccOperationCounter(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 28);
    }

    @Override
    public long getMvccLockCoordinatorVersion(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 32);
    }

    @Override
    public long getMvccLockCounter(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 40);
    }

    @Override
    public void setMvccLockCoordinatorVersion(long pageAddr, int idx, long lockCrd) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, this.offset(idx) + 32, lockCrd);
    }

    @Override
    public void setMvccLockCounter(long pageAddr, int idx, long lockCntr) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, this.offset(idx) + 40, lockCntr);
    }
}

