/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.managers.systemview.walker.AtomicLongViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.AtomicReferenceViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.AtomicSequenceViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.AtomicStampedViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.CountDownLatchViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.QueueViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.ReentrantLockViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SemaphoreViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SetViewWalker;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.datastructures.CacheDataStructuresManager;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureValue;
import org.apache.ignite.internal.processors.datastructures.DataStructureType;
import org.apache.ignite.internal.processors.datastructures.DistributedCollectionMetadata;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheCountDownLatchEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheCountDownLatchImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheCountDownLatchValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKeyImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheLockEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheLockImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheLockState;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueAdapter;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeaderKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheRemovable;
import org.apache.ignite.internal.processors.datastructures.GridCacheSemaphoreEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheSemaphoreImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheSemaphoreState;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeaderKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetProxy;
import org.apache.ignite.internal.processors.datastructures.VolatileAtomicDataStructureValue;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.lang.IgnitePredicateX;
import org.apache.ignite.internal.util.lang.gridfunc.PredicateCollectionView;
import org.apache.ignite.internal.util.lang.gridfunc.TransformCollectionView;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.GPR;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.systemview.view.datastructures.AtomicLongView;
import org.apache.ignite.spi.systemview.view.datastructures.AtomicReferenceView;
import org.apache.ignite.spi.systemview.view.datastructures.AtomicSequenceView;
import org.apache.ignite.spi.systemview.view.datastructures.AtomicStampedView;
import org.apache.ignite.spi.systemview.view.datastructures.CountDownLatchView;
import org.apache.ignite.spi.systemview.view.datastructures.QueueView;
import org.apache.ignite.spi.systemview.view.datastructures.ReentrantLockView;
import org.apache.ignite.spi.systemview.view.datastructures.SemaphoreView;
import org.apache.ignite.spi.systemview.view.datastructures.SetView;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public final class DataStructuresProcessor
extends GridProcessorAdapter
implements IgniteChangeGlobalStateSupport {
    public static final String VOLATILE_DATA_REGION_NAME = "volatileDsMemPlc";
    public static final String DEFAULT_VOLATILE_DS_GROUP_NAME = "default-volatile-ds-group";
    public static final String DEFAULT_DS_GROUP_NAME = "default-ds-group";
    private static final String DS_CACHE_NAME_PREFIX = "datastructures_";
    public static final String ATOMICS_CACHE_NAME = "ignite-sys-atomic-cache";
    public static final String QUEUES_VIEW = MetricUtils.metricName("ds", "queues");
    public static final String SETS_VIEW = MetricUtils.metricName("ds", "sets");
    public static final String LOCKS_VIEW = MetricUtils.metricName("ds", "reentrantlocks");
    public static final String SEMAPHORES_VIEW = MetricUtils.metricName("ds", "semaphores");
    public static final String LATCHES_VIEW = MetricUtils.metricName("ds", "countdownlatches");
    public static final String STAMPED_VIEW = MetricUtils.metricName("ds", "atomicstamped");
    public static final String REFERENCES_VIEW = MetricUtils.metricName("ds", "atomicreferences");
    public static final String LONGS_VIEW = MetricUtils.metricName("ds", "atomiclongs");
    public static final String SEQUENCES_VIEW = MetricUtils.metricName("ds", "atomicsequences");
    private static final String QUEUES_VIEW_DESC = "Data structure queues";
    private static final String SETS_VIEW_DESC = "Data structure sets";
    private static final String LOCKS_VIEW_DESC = "Data structure reentrant locks";
    private static final String SEMAPHORES_VIEW_DESC = "Data structure semaphores";
    private static final String LATCHES_VIEW_DESC = "Data structure count down latches";
    private static final String STAMPED_VIEW_DESC = "Data structure atomic stamped";
    private static final String REFERENCES_VIEW_DESC = "Data structure atomic references";
    private static final String LONGS_VIEW_DESC = "Data structure atomic longs";
    private static final String SEQUENCES_VIEW_DESC = "Data structure atomic sequences";
    private static final IgniteProductVersion SEPARATE_CACHE_PER_NON_COLLOCATED_SET_SINCE = IgniteProductVersion.fromString("2.7.0");
    private static final int INITIAL_CAPACITY = 10;
    private volatile CountDownLatch initLatch = new CountDownLatch(1);
    private boolean initFailed;
    private final ConcurrentMap<GridCacheInternalKey, GridCacheRemovable> dsMap;
    private final AtomicConfiguration dfltAtomicCfg;
    private final ConcurrentHashMap<Integer, UUID> qryIdMap = new ConcurrentHashMap();
    private final GridLocalEventListener lsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(final Event evt) {
            DataStructuresProcessor.this.ctx.closure().callLocalSafe(new GridPlainCallable<Object>(){

                @Override
                public Object call() {
                    DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                    UUID leftNodeId = discoEvt.eventNode().id();
                    for (GridCacheRemovable ds : DataStructuresProcessor.this.dsMap.values()) {
                        if (ds instanceof GridCacheSemaphoreEx) {
                            ((GridCacheSemaphoreEx)ds).onNodeRemoved(leftNodeId);
                            continue;
                        }
                        if (!(ds instanceof GridCacheLockEx)) continue;
                        ((GridCacheLockEx)ds).onNodeRemoved(leftNodeId);
                    }
                    return null;
                }
            }, false);
        }
    };

    public DataStructuresProcessor(GridKernalContext ctx) {
        super(ctx);
        this.dsMap = new ConcurrentHashMap<GridCacheInternalKey, GridCacheRemovable>(10);
        this.dfltAtomicCfg = ctx.config().getAtomicConfiguration();
    }

    @Override
    public void start() {
        this.ctx.event().addLocalEventListener(this.lsnr, 11, 12);
    }

    @Override
    public void onKernalStart(boolean active) {
        this.registerSystemViews();
        if (!active) {
            return;
        }
        this.onKernalStart0();
    }

    public void onBeforeActivate() {
        CountDownLatch latch0 = this.initLatch;
        if (latch0 == null || latch0.getCount() == 0L) {
            this.initLatch = new CountDownLatch(1);
        }
    }

    private void onKernalStart0() {
        this.initLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQuery(GridCacheContext cctx) throws IgniteCheckedException {
        if (!this.qryIdMap.containsKey(cctx.cacheId())) {
            DataStructuresProcessor dataStructuresProcessor = this;
            synchronized (dataStructuresProcessor) {
                if (!this.qryIdMap.containsKey(cctx.cacheId())) {
                    this.qryIdMap.put(cctx.cacheId(), cctx.continuousQueries().executeInternalQuery(new DataStructuresEntryListener(), new DataStructuresEntryFilter(), cctx.isReplicated() && cctx.affinityNode(), false, false, true));
                }
            }
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        for (GridCacheRemovable ds : this.dsMap.values()) {
            if (ds instanceof GridCacheSemaphoreEx) {
                ((GridCacheSemaphoreEx)ds).stop();
            }
            if (!(ds instanceof GridCacheLockEx)) continue;
            ((GridCacheLockEx)ds).onStop();
        }
        CountDownLatch init0 = this.initLatch;
        if (init0 != null && init0.getCount() > 0L) {
            this.initFailed = true;
            init0.countDown();
            this.initLatch = null;
        }
        Iterator<Map.Entry<Integer, UUID>> iter = this.qryIdMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, UUID> e = iter.next();
            iter.remove();
            GridCacheContext cctx = this.ctx.cache().context().cacheContext(e.getKey());
            cctx.continuousQueries().cancelInternalQuery(e.getValue());
        }
    }

    @Override
    public void onActivate(GridKernalContext ctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activating data structure processor [nodeId=" + ctx.localNodeId() + " topVer=" + ctx.discovery().topologyVersionEx() + " ]");
        }
        this.initFailed = false;
        this.qryIdMap.clear();
        ctx.event().addLocalEventListener(this.lsnr, 11, 12);
        this.restoreStructuresState(ctx);
        this.onKernalStart0();
    }

    private void registerSystemViews() {
        this.ctx.systemView().registerView(SEQUENCES_VIEW, SEQUENCES_VIEW_DESC, new AtomicSequenceViewWalker(), new PredicateCollectionView(this.dsMap.values(), v -> v instanceof IgniteAtomicSequence), AtomicSequenceView::new);
        this.ctx.systemView().registerView(LONGS_VIEW, LONGS_VIEW_DESC, new AtomicLongViewWalker(), new PredicateCollectionView(this.dsMap.values(), v -> v instanceof IgniteAtomicLong), AtomicLongView::new);
        this.ctx.systemView().registerView(REFERENCES_VIEW, REFERENCES_VIEW_DESC, new AtomicReferenceViewWalker(), new PredicateCollectionView(this.dsMap.values(), v -> v instanceof IgniteAtomicReference), AtomicReferenceView::new);
        this.ctx.systemView().registerView(STAMPED_VIEW, STAMPED_VIEW_DESC, new AtomicStampedViewWalker(), new PredicateCollectionView(this.dsMap.values(), v -> v instanceof IgniteAtomicStamped), AtomicStampedView::new);
        this.ctx.systemView().registerView(LATCHES_VIEW, LATCHES_VIEW_DESC, new CountDownLatchViewWalker(), new PredicateCollectionView(this.dsMap.values(), v -> v instanceof IgniteCountDownLatch), CountDownLatchView::new);
        this.ctx.systemView().registerView(SEMAPHORES_VIEW, SEMAPHORES_VIEW_DESC, new SemaphoreViewWalker(), new PredicateCollectionView(this.dsMap.values(), v -> v instanceof IgniteSemaphore), SemaphoreView::new);
        this.ctx.systemView().registerView(LOCKS_VIEW, LOCKS_VIEW_DESC, new ReentrantLockViewWalker(), new PredicateCollectionView(this.dsMap.values(), v -> v instanceof IgniteLock), ReentrantLockView::new);
        this.ctx.systemView().registerInnerCollectionView(QUEUES_VIEW, QUEUES_VIEW_DESC, new QueueViewWalker(), new TransformCollectionView<CacheDataStructuresManager, DynamicCacheDescriptor>(this.ctx.cache().cacheDescriptors().values(), desc -> this.ctx.cache().cache(desc.cacheName()).context().dataStructures(), desc -> desc.cacheType() == CacheType.DATA_STRUCTURES), cctx -> cctx.queues().values(), (cctx, queue) -> new QueueView((GridCacheQueueProxy<?>)queue));
        this.ctx.systemView().registerInnerCollectionView(SETS_VIEW, SETS_VIEW_DESC, new SetViewWalker(), F.viewReadOnly(this.ctx.cache().cacheDescriptors().values(), desc -> this.ctx.cache().cache(desc.cacheName()).context().dataStructures(), desc -> desc.cacheType() == CacheType.DATA_STRUCTURES), cctx -> cctx.sets().values(), (cctx, set) -> new SetView((GridCacheSetProxy<?>)set));
    }

    public void restoreStructuresState(GridKernalContext ctx) {
        this.onKernalStart0();
        try {
            for (GridCacheRemovable v : this.dsMap.values()) {
                if (!(v instanceof IgniteChangeGlobalStateSupport)) continue;
                ((IgniteChangeGlobalStateSupport)((Object)v)).onActivate(ctx);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed restore data structures state", e);
        }
    }

    @Override
    public void onDeActivate(GridKernalContext ctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate data structure processor [nodeId=" + ctx.localNodeId() + ", topVer=" + ctx.discovery().topologyVersionEx() + "]");
        }
        ctx.event().removeLocalEventListener(this.lsnr, 11, 12);
        this.onKernalStop(false);
        this.initLatch = null;
        for (GridCacheRemovable v : this.dsMap.values()) {
            if (!(v instanceof IgniteChangeGlobalStateSupport)) continue;
            ((IgniteChangeGlobalStateSupport)((Object)v)).onDeActivate(ctx);
        }
    }

    void onRemoved(GridCacheInternalKey key, GridCacheRemovable obj) {
        this.dsMap.remove(key, obj);
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        UUID nodeId = this.ctx.localNodeId();
        for (Map.Entry e : this.dsMap.entrySet()) {
            GridCacheRemovable obj = (GridCacheRemovable)e.getValue();
            if (clusterRestarted) {
                obj.onRemoved();
                this.dsMap.remove(e.getKey(), obj);
            } else {
                obj.needCheckNotRemoved();
            }
            if (!(obj instanceof GridCacheLockEx)) continue;
            ((GridCacheLockEx)obj).onReconnected(nodeId);
        }
        for (GridCacheContext cctx : this.ctx.cache().context().cacheContexts()) {
            cctx.dataStructures().onReconnected(clusterRestarted);
        }
        return null;
    }

    public static boolean isDataStructureCache(String cacheName) {
        return cacheName != null && (cacheName.startsWith(ATOMICS_CACHE_NAME) || cacheName.startsWith(DS_CACHE_NAME_PREFIX) || cacheName.equals(DEFAULT_DS_GROUP_NAME) || cacheName.equals(DEFAULT_VOLATILE_DS_GROUP_NAME));
    }

    public static boolean isReservedGroup(@Nullable String grpName) {
        return grpName != null && (DEFAULT_DS_GROUP_NAME.equals(grpName) || grpName.startsWith(DEFAULT_VOLATILE_DS_GROUP_NAME));
    }

    public final IgniteAtomicSequence sequence(final String name, final @Nullable AtomicConfiguration cfg, final long initVal, final boolean create) throws IgniteCheckedException {
        return this.getAtomic(new AtomicAccessor<GridCacheAtomicSequenceEx>(){

            @Override
            public T2<GridCacheAtomicSequenceEx, AtomicDataStructureValue> get(GridCacheInternalKey key, AtomicDataStructureValue val, IgniteInternalCache cache) throws IgniteCheckedException {
                long upBound;
                long locCntr;
                long off;
                GridCacheAtomicSequenceValue seqVal = (GridCacheAtomicSequenceValue)DataStructuresProcessor.this.cast(val, GridCacheAtomicSequenceValue.class);
                GridCacheAtomicSequenceEx seq = (GridCacheAtomicSequenceEx)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsMap.get(key), GridCacheAtomicSequenceEx.class);
                if (seq != null) {
                    assert (seqVal != null);
                    return new T2<GridCacheAtomicSequenceEx, Object>(seq, null);
                }
                if (seqVal == null && !create) {
                    return null;
                }
                AtomicConfiguration cfg0 = cfg != null ? cfg : DataStructuresProcessor.this.dfltAtomicCfg;
                long l = off = cfg0.getAtomicSequenceReserveSize() > 1 ? (long)(cfg0.getAtomicSequenceReserveSize() - 1) : 1L;
                if (seqVal == null) {
                    locCntr = initVal;
                    upBound = locCntr + off;
                    seqVal = new GridCacheAtomicSequenceValue(upBound + 1L);
                } else {
                    locCntr = seqVal.get();
                    upBound = locCntr + off;
                    seqVal.set(upBound + 1L);
                }
                seq = new GridCacheAtomicSequenceImpl(name, key, cache, cfg0.getAtomicSequenceReserveSize(), locCntr, upBound);
                return new T2<GridCacheAtomicSequenceEx, AtomicDataStructureValue>(seq, seqVal);
            }
        }, cfg, name, DataStructureType.ATOMIC_SEQ, create, GridCacheAtomicSequenceEx.class);
    }

    final void removeSequence(String name, String grpName) throws IgniteCheckedException {
        this.removeDataStructure(null, name, grpName, DataStructureType.ATOMIC_SEQ, null);
    }

    public final IgniteAtomicLong atomicLong(final String name, @Nullable AtomicConfiguration cfg, final long initVal, final boolean create) throws IgniteCheckedException {
        return this.getAtomic(new AtomicAccessor<GridCacheAtomicLongEx>(){

            @Override
            public T2<GridCacheAtomicLongEx, AtomicDataStructureValue> get(GridCacheInternalKey key, AtomicDataStructureValue val, IgniteInternalCache cache) throws IgniteCheckedException {
                GridCacheAtomicLongEx a = (GridCacheAtomicLongEx)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsMap.get(key), GridCacheAtomicLongEx.class);
                if (a != null) {
                    assert (val != null);
                    return new T2<GridCacheAtomicLongEx, Object>(a, null);
                }
                if (val == null && !create) {
                    return null;
                }
                GridCacheAtomicLongValue retVal = val == null ? new GridCacheAtomicLongValue(initVal) : null;
                a = new GridCacheAtomicLongImpl(name, key, cache);
                return new T2<GridCacheAtomicLongEx, AtomicDataStructureValue>(a, retVal);
            }
        }, cfg, name, DataStructureType.ATOMIC_LONG, create, GridCacheAtomicLongEx.class);
    }

    @Nullable
    private <T extends GridCacheRemovable> T getAtomic(final AtomicAccessor<T> c, @Nullable AtomicConfiguration cfg, final String name, final DataStructureType type, final boolean create, Class<? extends T> cls) throws IgniteCheckedException {
        String grpName;
        A.notNull(name, "name");
        this.awaitInitialization();
        if (cfg == null) {
            this.checkAtomicsConfiguration();
            cfg = this.dfltAtomicCfg;
        }
        String dataRegionName = null;
        if (type.isVolatile()) {
            String volatileGrpName = DEFAULT_VOLATILE_DS_GROUP_NAME;
            dataRegionName = VOLATILE_DATA_REGION_NAME;
            grpName = volatileGrpName = volatileGrpName + "@" + dataRegionName;
        } else {
            grpName = cfg.getGroupName() != null ? cfg.getGroupName() : DEFAULT_DS_GROUP_NAME;
        }
        String cacheName = "ignite-sys-atomic-cache@" + grpName;
        IgniteInternalCache cache0 = this.ctx.cache().cache(cacheName);
        if (cache0 == null) {
            if (!create && this.ctx.cache().cacheDescriptor(cacheName) == null) {
                return null;
            }
            this.ctx.cache().dynamicStartCache(this.cacheConfiguration(cfg, cacheName, grpName, dataRegionName), cacheName, null, CacheType.DATA_STRUCTURES, false, false, true, true).get();
            cache0 = this.ctx.cache().cache(cacheName);
            assert (cache0 != null);
        }
        final IgniteInternalCache cache = cache0;
        this.startQuery(cache.context());
        final GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name, grpName);
        GridCacheRemovable dataStructure = (GridCacheRemovable)this.cast(this.dsMap.get(key), cls);
        if (dataStructure != null) {
            return (T)dataStructure;
        }
        return (T)((GridCacheRemovable)DataStructuresProcessor.retryTopologySafe(new IgniteOutClosureX<T>(){

            /*
             * Exception decompiling
             */
            @Override
            public T applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }));
    }

    private boolean isObsolete(AtomicDataStructureValue val) {
        return val != null && val instanceof VolatileAtomicDataStructureValue && ((VolatileAtomicDataStructureValue)val).gridStartTime() != this.ctx.discovery().gridStartTime();
    }

    final void removeAtomicLong(String name, @Nullable String grpName) throws IgniteCheckedException {
        this.removeDataStructure(null, name, grpName, DataStructureType.ATOMIC_LONG, null);
    }

    private <T> void removeDataStructure(final @Nullable IgnitePredicateX<AtomicDataStructureValue> pred, final String name, String grpName, final DataStructureType type, final @Nullable IgniteInClosureX<T> afterRmv) throws IgniteCheckedException {
        assert (name != null);
        assert (grpName != null);
        assert (type != null);
        this.awaitInitialization();
        final String cacheName = "ignite-sys-atomic-cache@" + grpName;
        final GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name, grpName);
        DataStructuresProcessor.retryTopologySafe(new IgniteOutClosureX<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object applyx() throws IgniteCheckedException {
                IgniteInternalCache cache = DataStructuresProcessor.this.ctx.cache().cache(cacheName);
                if (cache == null) return null;
                if (!cache.context().gate().enterIfNotStopped()) return null;
                boolean isInterrupted = Thread.interrupted();
                while (true) {
                    try {
                        AtomicDataStructureValue val;
                        Throwable throwable;
                        GridNearTxLocal tx;
                        block22: {
                            Object var6_9;
                            block23: {
                                block24: {
                                    tx = cache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
                                    throwable = null;
                                    val = (AtomicDataStructureValue)cache.get(key);
                                    if (val != null) break block22;
                                    var6_9 = null;
                                    if (tx == null) break block23;
                                    if (throwable == null) break block24;
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block23;
                                }
                                tx.close();
                            }
                            cache.context().gate().leave();
                            if (!isInterrupted) return var6_9;
                            Thread.currentThread().interrupt();
                            return var6_9;
                        }
                        try {
                            if (val.type() != type) {
                                throw new IgniteCheckedException("Data structure has different type [name=" + name + ", expectedType=" + (Object)((Object)type) + ", actualType=" + (Object)((Object)val.type()) + ']');
                            }
                            if (pred != null && !pred.applyx(val)) break;
                            cache.remove(key);
                            tx.commit();
                            if (afterRmv == null) break;
                            afterRmv.applyx(null);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                        finally {
                            if (tx != null) {
                                if (throwable != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    tx.close();
                                }
                            }
                        }
                    }
                    catch (IgniteCheckedException e) {
                        if (!X.hasCause((Throwable)e, IgniteInterruptedCheckedException.class, InterruptedException.class)) throw e;
                        isInterrupted = Thread.interrupted();
                        continue;
                    }
                    break;
                }
                cache.context().gate().leave();
                if (!isInterrupted) return null;
                Thread.currentThread().interrupt();
                return null;
                catch (Throwable throwable) {
                    cache.context().gate().leave();
                    if (!isInterrupted) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        });
    }

    public void suspend(String cacheName) {
        for (Map.Entry e : this.dsMap.entrySet()) {
            String cacheName0 = "ignite-sys-atomic-cache@" + ((GridCacheInternalKey)e.getKey()).groupName();
            if (!cacheName0.equals(cacheName)) continue;
            ((GridCacheRemovable)e.getValue()).suspend();
        }
    }

    public void restart(String cacheName, IgniteInternalCache cache) {
        for (Map.Entry e : this.dsMap.entrySet()) {
            String cacheName0 = "ignite-sys-atomic-cache@" + ((GridCacheInternalKey)e.getKey()).groupName();
            if (!cacheName0.equals(cacheName)) continue;
            if (cache != null) {
                ((GridCacheRemovable)e.getValue()).restart(cache);
                continue;
            }
            ((GridCacheRemovable)e.getValue()).onRemoved();
            this.dsMap.remove(e.getKey(), e.getValue());
        }
    }

    public final <T> IgniteAtomicReference<T> atomicReference(final String name, @Nullable AtomicConfiguration cfg, final T initVal, final boolean create) throws IgniteCheckedException {
        return this.getAtomic(new AtomicAccessor<GridCacheAtomicReferenceEx>(){

            @Override
            public T2<GridCacheAtomicReferenceEx, AtomicDataStructureValue> get(GridCacheInternalKey key, AtomicDataStructureValue val, IgniteInternalCache cache) throws IgniteCheckedException {
                GridCacheAtomicReferenceImpl ref = (GridCacheAtomicReferenceImpl)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsMap.get(key), GridCacheAtomicReferenceEx.class);
                if (ref != null) {
                    assert (val != null);
                    return new T2<GridCacheAtomicReferenceEx, Object>(ref, null);
                }
                if (val == null && !create) {
                    return null;
                }
                GridCacheAtomicReferenceValue<Object> retVal = val == null ? new GridCacheAtomicReferenceValue<Object>(initVal) : null;
                ref = new GridCacheAtomicReferenceImpl(name, key, cache);
                return new T2<GridCacheAtomicReferenceEx, AtomicDataStructureValue>(ref, retVal);
            }
        }, cfg, name, DataStructureType.ATOMIC_REF, create, GridCacheAtomicReferenceEx.class);
    }

    final void removeAtomicReference(String name, @Nullable String grpName) throws IgniteCheckedException {
        this.removeDataStructure(null, name, grpName, DataStructureType.ATOMIC_REF, null);
    }

    public final <T, S> IgniteAtomicStamped<T, S> atomicStamped(final String name, @Nullable AtomicConfiguration cfg, final T initVal, final S initStamp, final boolean create) throws IgniteCheckedException {
        return this.getAtomic(new AtomicAccessor<GridCacheAtomicStampedEx>(){

            @Override
            public T2<GridCacheAtomicStampedEx, AtomicDataStructureValue> get(GridCacheInternalKey key, AtomicDataStructureValue val, IgniteInternalCache cache) throws IgniteCheckedException {
                GridCacheAtomicStampedImpl stmp = (GridCacheAtomicStampedImpl)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsMap.get(key), GridCacheAtomicStampedEx.class);
                if (stmp != null) {
                    assert (val != null);
                    return new T2<GridCacheAtomicStampedEx, Object>(stmp, null);
                }
                if (val == null && !create) {
                    return null;
                }
                GridCacheAtomicStampedValue<Object, Object> retVal = val == null ? new GridCacheAtomicStampedValue<Object, Object>(initVal, initStamp) : null;
                stmp = new GridCacheAtomicStampedImpl(name, key, cache);
                return new T2<GridCacheAtomicStampedEx, AtomicDataStructureValue>(stmp, retVal);
            }
        }, cfg, name, DataStructureType.ATOMIC_STAMPED, create, GridCacheAtomicStampedEx.class);
    }

    final void removeAtomicStamped(String name, String grpName) throws IgniteCheckedException {
        this.removeDataStructure(null, name, grpName, DataStructureType.ATOMIC_STAMPED, null);
    }

    public final <T> IgniteQueue<T> queue(final String name, @Nullable String grpName, int cap, final @Nullable CollectionConfiguration cfg) throws IgniteCheckedException {
        A.notNull(name, "name");
        if (cfg != null && cap <= 0) {
            cap = Integer.MAX_VALUE;
        }
        final int cap0 = cap;
        final boolean create = cfg != null;
        return (IgniteQueue)this.getCollection(new IgniteClosureX<GridCacheContext, IgniteQueue<T>>(){

            @Override
            public IgniteQueue<T> applyx(GridCacheContext ctx) throws IgniteCheckedException {
                return ctx.dataStructures().queue(name, cap0, DataStructuresProcessor.this.isCollocated(cfg), create);
            }
        }, cfg, name, grpName, DataStructureType.QUEUE, create, false);
    }

    private boolean isCollocated(CollectionConfiguration cfg) {
        return cfg != null && (cfg.isCollocated() || cfg.getCacheMode() != CacheMode.PARTITIONED);
    }

    private CacheConfiguration cacheConfiguration(AtomicConfiguration cfg, String name, String grpName, String dataRegionName) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(name);
        ccfg.setGroupName(grpName);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setCacheMode(cfg.getCacheMode());
        ccfg.setNodeFilter(CacheConfiguration.ALL_NODES);
        ccfg.setAffinity(cfg.getAffinity());
        ccfg.setDataRegionName(dataRegionName);
        if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
            ccfg.setBackups(cfg.getBackups());
        }
        return ccfg;
    }

    private CacheConfiguration cacheConfiguration(CollectionConfiguration cfg, String name, String grpName) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(name);
        ccfg.setGroupName(grpName);
        ccfg.setBackups(cfg.getBackups());
        ccfg.setCacheMode(cfg.getCacheMode());
        ccfg.setAtomicityMode(cfg.getAtomicityMode());
        ccfg.setNodeFilter(cfg.getNodeFilter());
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        return ccfg;
    }

    private CacheConfiguration metaCacheConfiguration(CollectionConfiguration cfg, String name, String grpName) {
        CacheConfiguration ccfg = this.cacheConfiguration(cfg, name, grpName);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        return ccfg;
    }

    private IgniteInternalCache compatibleCache(CollectionConfiguration cfg, String grpName, DataStructureType dsType, String dsName, boolean separated) throws IgniteCheckedException {
        String cacheName = DS_CACHE_NAME_PREFIX + (Object)((Object)cfg.getAtomicityMode()) + "_" + (Object)((Object)cfg.getCacheMode()) + "_" + cfg.getBackups() + "@" + grpName;
        IgniteInternalCache cache = this.ctx.cache().cache(cacheName);
        if (separated && (cache == null || !cache.containsKey(new GridCacheSetHeaderKey(dsName)))) {
            cacheName = cacheName + "#" + dsType.name() + "_" + dsName;
            cache = this.ctx.cache().cache(cacheName);
        }
        if (cache == null) {
            this.ctx.cache().dynamicStartCache(this.cacheConfiguration(cfg, cacheName, grpName), cacheName, null, CacheType.DATA_STRUCTURES, false, false, true, true).get();
        } else {
            String clsName2;
            IgnitePredicate<ClusterNode> cacheNodeFilter = cache.context().group().nodeFilter();
            String clsName1 = cacheNodeFilter != null ? cacheNodeFilter.getClass().getName() : CacheConfiguration.IgniteAllNodesPredicate.class.getName();
            String string = clsName2 = cfg.getNodeFilter() != null ? cfg.getNodeFilter().getClass().getName() : CacheConfiguration.IgniteAllNodesPredicate.class.getName();
            if (!clsName1.equals(clsName2)) {
                throw new IgniteCheckedException("Could not add collection to group " + grpName + " because of different node filters [existing=" + clsName1 + ", new=" + clsName2 + "]");
            }
        }
        cache = this.ctx.cache().getOrStartCache(cacheName);
        assert (cache != null);
        return cache;
    }

    public void removeQueue(final String name, final GridCacheContext cctx) throws IgniteCheckedException {
        assert (name != null);
        assert (cctx != null);
        CIX1<GridCacheQueueHeader> afterRmv = new CIX1<GridCacheQueueHeader>(){

            @Override
            public void applyx(GridCacheQueueHeader hdr) throws IgniteCheckedException {
                hdr = (GridCacheQueueHeader)cctx.cache().withNoRetries().getAndRemove(new GridCacheQueueHeaderKey(name));
                if (hdr == null || hdr.empty()) {
                    return;
                }
                GridCacheQueueAdapter.removeKeys(cctx.cache(), hdr.id(), name, hdr.collocated(), hdr.head(), hdr.tail(), 0);
            }
        };
        this.removeDataStructure(null, name, cctx.group().name(), DataStructureType.QUEUE, afterRmv);
    }

    @Nullable
    private <T> T getCollection(final IgniteClosureX<GridCacheContext, T> c, @Nullable CollectionConfiguration cfg, String name, @Nullable String grpName, DataStructureType type, boolean create, boolean separated) throws IgniteCheckedException {
        AtomicDataStructureValue oldVal;
        IgniteInternalCache cache;
        this.awaitInitialization();
        assert (name != null);
        assert (type.isCollection()) : type;
        assert (!create || cfg != null);
        if (grpName == null) {
            grpName = cfg != null && cfg.getGroupName() != null ? cfg.getGroupName() : DEFAULT_DS_GROUP_NAME;
        }
        String metaCacheName = "ignite-sys-atomic-cache@" + grpName;
        IgniteInternalCache<GridCacheInternalKeyImpl, DistributedCollectionMetadata> metaCache0 = this.ctx.cache().cache(metaCacheName);
        if (metaCache0 == null) {
            CacheConfiguration ccfg = null;
            if (!create) {
                DynamicCacheDescriptor desc = this.ctx.cache().cacheDescriptor(metaCacheName);
                if (desc == null) {
                    return null;
                }
            } else {
                ccfg = this.metaCacheConfiguration(cfg, metaCacheName, grpName);
            }
            this.ctx.cache().dynamicStartCache(ccfg, metaCacheName, null, CacheType.DATA_STRUCTURES, false, false, true, true).get();
            metaCache0 = this.ctx.cache().cache(metaCacheName);
            assert (metaCache0 != null);
        }
        IgniteInternalCache<GridCacheInternalKeyImpl, DistributedCollectionMetadata> metaCache = metaCache0;
        if (create) {
            cache = this.compatibleCache(cfg, grpName, type, name, separated);
            DistributedCollectionMetadata newVal = new DistributedCollectionMetadata(type, cfg, cache.name());
            oldVal = metaCache.getAndPutIfAbsent(new GridCacheInternalKeyImpl(name, grpName), newVal);
        } else {
            oldVal = (AtomicDataStructureValue)metaCache.get(new GridCacheInternalKeyImpl(name, grpName));
            if (oldVal == null) {
                return null;
            }
            if (!(oldVal instanceof DistributedCollectionMetadata)) {
                throw new IgniteCheckedException("Another data structure with the same name already created [name=" + name + ", newType=" + (Object)((Object)type) + ", existingType=" + (Object)((Object)oldVal.type()) + ']');
            }
            cache = this.ctx.cache().getOrStartCache(((DistributedCollectionMetadata)oldVal).cacheName());
            if (cache == null) {
                return null;
            }
        }
        if (oldVal != null) {
            if (oldVal.type() != type) {
                throw new IgniteCheckedException("Another data structure with the same name already created [name=" + name + ", newType=" + (Object)((Object)type) + ", existingType=" + (Object)((Object)oldVal.type()) + ']');
            }
            assert (oldVal instanceof DistributedCollectionMetadata);
            if (cfg != null && ((DistributedCollectionMetadata)oldVal).configuration().isCollocated() != cfg.isCollocated()) {
                throw new IgniteCheckedException("Another collection with the same name but different configuration already created [name=" + name + ", newCollocated=" + cfg.isCollocated() + ", existingCollocated=" + !cfg.isCollocated() + ']');
            }
        }
        return DataStructuresProcessor.retryTopologySafe(new IgniteOutClosureX<T>(){

            @Override
            public T applyx() throws IgniteCheckedException {
                return c.applyx(cache.context());
            }
        });
    }

    private void awaitInitialization() {
        CountDownLatch latch0 = this.initLatch;
        if (latch0 == null) {
            throw new IllegalStateException("Ignite cluster is not active");
        }
        if (latch0.getCount() > 0L) {
            try {
                U.await(latch0);
                if (this.initFailed) {
                    throw new IllegalStateException("Failed to initialize data structures processor.");
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new IllegalStateException("Failed to initialize data structures processor (thread has been interrupted).", e);
            }
        }
    }

    public IgniteCountDownLatch countDownLatch(final String name, @Nullable AtomicConfiguration cfg, final int cnt, final boolean autoDel, final boolean create) throws IgniteCheckedException {
        if (create) {
            A.ensure(cnt >= 0, "count can not be negative");
        }
        return this.getAtomic(new AtomicAccessor<GridCacheCountDownLatchEx>(){

            @Override
            public T2<GridCacheCountDownLatchEx, AtomicDataStructureValue> get(GridCacheInternalKey key, AtomicDataStructureValue val, IgniteInternalCache cache) throws IgniteCheckedException {
                GridCacheCountDownLatchValue latchVal;
                GridCacheCountDownLatchEx latch = (GridCacheCountDownLatchEx)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsMap.get(key), GridCacheCountDownLatchEx.class);
                if (latch != null) {
                    assert (val != null);
                    return new T2<GridCacheCountDownLatchEx, Object>(latch, null);
                }
                if (val == null && !create) {
                    return null;
                }
                GridCacheCountDownLatchValue retVal = val == null ? new GridCacheCountDownLatchValue(cnt, autoDel, DataStructuresProcessor.this.ctx.discovery().gridStartTime()) : null;
                GridCacheCountDownLatchValue gridCacheCountDownLatchValue = latchVal = retVal != null ? retVal : (GridCacheCountDownLatchValue)val;
                assert (latchVal != null);
                latch = new GridCacheCountDownLatchImpl(name, latchVal.initialCount(), latchVal.autoDelete(), key, cache);
                return new T2<GridCacheCountDownLatchEx, AtomicDataStructureValue>(latch, retVal);
            }
        }, cfg, name, DataStructureType.COUNT_DOWN_LATCH, create, GridCacheCountDownLatchEx.class);
    }

    public void removeCountDownLatch(String name, String grpName) throws IgniteCheckedException {
        this.removeDataStructure(new IgnitePredicateX<AtomicDataStructureValue>(){

            @Override
            public boolean applyx(AtomicDataStructureValue val) throws IgniteCheckedException {
                assert (val != null && val instanceof GridCacheCountDownLatchValue);
                GridCacheCountDownLatchValue latchVal = (GridCacheCountDownLatchValue)val;
                if (latchVal.get() > 0) {
                    throw new IgniteCheckedException("Failed to remove count down latch with non-zero count: " + latchVal.get());
                }
                return true;
            }
        }, name, grpName, DataStructureType.COUNT_DOWN_LATCH, null);
    }

    public IgniteSemaphore semaphore(final String name, @Nullable AtomicConfiguration cfg, final int cnt, final boolean failoverSafe, final boolean create) throws IgniteCheckedException {
        return this.getAtomic(new AtomicAccessor<GridCacheSemaphoreEx>(){

            @Override
            public T2<GridCacheSemaphoreEx, AtomicDataStructureValue> get(GridCacheInternalKey key, AtomicDataStructureValue val, IgniteInternalCache cache) throws IgniteCheckedException {
                GridCacheSemaphoreEx sem = (GridCacheSemaphoreEx)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsMap.get(key), GridCacheSemaphoreEx.class);
                if (sem != null) {
                    assert (val != null);
                    return new T2<GridCacheSemaphoreEx, Object>(sem, null);
                }
                if (val == null && !create) {
                    return null;
                }
                GridCacheSemaphoreState retVal = val == null ? new GridCacheSemaphoreState(cnt, new HashMap<UUID, Integer>(), failoverSafe, DataStructuresProcessor.this.ctx.discovery().gridStartTime()) : null;
                GridCacheSemaphoreImpl sem0 = new GridCacheSemaphoreImpl(name, key, cache);
                if (val != null && failoverSafe) {
                    GridCacheSemaphoreState semState = (GridCacheSemaphoreState)val;
                    boolean updated = false;
                    Map<UUID, Integer> waiters = semState.getWaiters();
                    Integer permit = ((GridCacheSemaphoreState)val).getCount();
                    for (UUID nodeId : new HashSet<UUID>(waiters.keySet())) {
                        ClusterNode node = DataStructuresProcessor.this.ctx.cluster().get().node(nodeId);
                        if (node != null) continue;
                        permit = permit + waiters.get(nodeId);
                        waiters.remove(nodeId);
                        updated = true;
                    }
                    if (updated) {
                        semState.setWaiters(waiters);
                        semState.setCount(permit);
                        retVal = semState;
                    }
                }
                return new T2<GridCacheSemaphoreEx, AtomicDataStructureValue>(sem0, retVal);
            }
        }, cfg, name, DataStructureType.SEMAPHORE, create, GridCacheSemaphoreEx.class);
    }

    public void removeSemaphore(String name, String grpName) throws IgniteCheckedException {
        this.removeDataStructure(new IgnitePredicateX<AtomicDataStructureValue>(){

            @Override
            public boolean applyx(AtomicDataStructureValue val) throws IgniteCheckedException {
                assert (val != null && val instanceof GridCacheSemaphoreState);
                GridCacheSemaphoreState semVal = (GridCacheSemaphoreState)val;
                if (semVal.getCount() < 0) {
                    throw new IgniteCheckedException("Failed to remove semaphore with blocked threads. ");
                }
                return true;
            }
        }, name, grpName, DataStructureType.SEMAPHORE, null);
    }

    public IgniteLock reentrantLock(final String name, @Nullable AtomicConfiguration cfg, final boolean failoverSafe, final boolean fair, final boolean create) throws IgniteCheckedException {
        return this.getAtomic(new AtomicAccessor<GridCacheLockEx>(){

            @Override
            public T2<GridCacheLockEx, AtomicDataStructureValue> get(GridCacheInternalKey key, AtomicDataStructureValue val, IgniteInternalCache cache) throws IgniteCheckedException {
                GridCacheLockEx reentrantLock = (GridCacheLockEx)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsMap.get(key), GridCacheLockEx.class);
                if (reentrantLock != null) {
                    assert (val != null);
                    return new T2<GridCacheLockEx, Object>(reentrantLock, null);
                }
                if (val == null && !create) {
                    return new T2<Object, Object>(null, null);
                }
                GridCacheLockState retVal = val == null ? new GridCacheLockState(0, DataStructuresProcessor.this.ctx.localNodeId(), 0L, failoverSafe, fair, DataStructuresProcessor.this.ctx.discovery().gridStartTime()) : null;
                GridCacheLockImpl reentrantLock0 = new GridCacheLockImpl(name, key, cache);
                return new T2<GridCacheLockEx, AtomicDataStructureValue>(reentrantLock0, retVal);
            }
        }, cfg, name, DataStructureType.REENTRANT_LOCK, create, GridCacheLockEx.class);
    }

    public void removeReentrantLock(String name, String grpName, final boolean broken) throws IgniteCheckedException {
        this.removeDataStructure(new IgnitePredicateX<AtomicDataStructureValue>(){

            @Override
            public boolean applyx(AtomicDataStructureValue val) throws IgniteCheckedException {
                assert (val != null && val instanceof GridCacheLockState);
                GridCacheLockState lockVal = (GridCacheLockState)val;
                if (lockVal.get() > 0 && !broken) {
                    throw new IgniteCheckedException("Failed to remove reentrant lock with blocked threads. ");
                }
                return true;
            }
        }, name, grpName, DataStructureType.REENTRANT_LOCK, null);
    }

    @Nullable
    public <T> IgniteSet<T> set(final String name, @Nullable String grpName, @Nullable CollectionConfiguration cfg) throws IgniteCheckedException {
        A.notNull(name, "name");
        final boolean create = cfg != null;
        final boolean collocated = this.isCollocated(cfg);
        final boolean separated = !collocated && U.isOldestNodeVersionAtLeast(SEPARATE_CACHE_PER_NON_COLLOCATED_SET_SINCE, this.ctx.grid().cluster().nodes());
        return (IgniteSet)this.getCollection(new CX1<GridCacheContext, IgniteSet<T>>(){

            @Override
            public IgniteSet<T> applyx(GridCacheContext cctx) throws IgniteCheckedException {
                return cctx.dataStructures().set(name, collocated, create, separated);
            }
        }, cfg, name, grpName, DataStructureType.SET, create, separated);
    }

    @Nullable
    public <T> IgniteSet<T> set(String name, int cacheId, boolean collocated, boolean separated) throws IgniteCheckedException {
        A.notNull(name, "name");
        DynamicCacheDescriptor desc = this.ctx.cache().cacheDescriptor(cacheId);
        if (desc == null) {
            return null;
        }
        IgniteInternalCache cache = this.ctx.cache().cache(desc.cacheName());
        if (cache == null) {
            return null;
        }
        return cache.context().dataStructures().set(name, collocated, false, separated);
    }

    public void removeSet(final String name, final GridCacheContext cctx) throws IgniteCheckedException {
        assert (name != null);
        assert (cctx != null);
        CIX1<GridCacheSetHeader> afterRmv = new CIX1<GridCacheSetHeader>(){

            @Override
            public void applyx(GridCacheSetHeader hdr) throws IgniteCheckedException {
                hdr = (GridCacheSetHeader)cctx.cache().withNoRetries().getAndRemove(new GridCacheSetHeaderKey(name));
                if (hdr != null) {
                    cctx.dataStructures().removeSetData(hdr.id(), hdr.separated());
                }
            }
        };
        this.removeDataStructure(null, name, cctx.group().name(), DataStructureType.SET, afterRmv);
    }

    public static <R> R retry(IgniteLogger log, Callable<R> call) throws IgniteCheckedException {
        try {
            return GridCacheUtils.retryTopologySafe(call);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Nullable
    private <R> R cast(@Nullable Object obj, Class<R> cls) throws IgniteCheckedException {
        if (obj == null) {
            return null;
        }
        if (cls.isInstance(obj)) {
            return (R)obj;
        }
        return null;
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Data structure processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>   dsMapSize: " + this.dsMap.size(), new Object[0]);
    }

    private void checkAtomicsConfiguration() throws IgniteException {
        if (this.dfltAtomicCfg == null) {
            throw new IgniteException("Atomic data structure can not be created, need to provide AtomicConfiguration.");
        }
    }

    private static <T> T retryTopologySafe(IgniteOutClosureX<T> c) throws IgniteCheckedException {
        for (int i = 0; i < GridCacheAdapter.MAX_RETRIES; ++i) {
            try {
                return c.applyx();
            }
            catch (NodeStoppingException e) {
                throw e;
            }
            catch (IgniteCheckedException e) {
                if (i == GridCacheAdapter.MAX_RETRIES - 1) {
                    throw e;
                }
                ClusterTopologyCheckedException topErr = e.getCause(ClusterTopologyCheckedException.class);
                if (topErr == null || topErr instanceof ClusterTopologyServerNotFoundException) {
                    throw e;
                }
                IgniteInternalFuture<?> fut = topErr.retryReadyFuture();
                if (fut == null) continue;
                fut.get();
                continue;
            }
        }
        assert (false);
        return null;
    }

    static /* synthetic */ boolean access$500(DataStructuresProcessor x0, AtomicDataStructureValue x1) {
        return x0.isObsolete(x1);
    }

    static /* synthetic */ IgniteLogger access$600(DataStructuresProcessor x0) {
        return x0.log;
    }

    private static interface AtomicAccessor<T> {
        public T2<T, AtomicDataStructureValue> get(GridCacheInternalKey var1, @Nullable AtomicDataStructureValue var2, IgniteInternalCache var3) throws IgniteCheckedException;
    }

    private class DataStructuresEntryListener
    implements CacheEntryUpdatedListener<GridCacheInternalKey, GridCacheInternal> {
        private DataStructuresEntryListener() {
        }

        public void onUpdated(Iterable<CacheEntryEvent<? extends GridCacheInternalKey, ? extends GridCacheInternal>> evts) throws CacheEntryListenerException {
            for (CacheEntryEvent<? extends GridCacheInternalKey, ? extends GridCacheInternal> evt : evts) {
                if (evt.getEventType() == EventType.CREATED || evt.getEventType() == EventType.UPDATED) {
                    VolatileAtomicDataStructureValue val;
                    GridCacheInternalKey key;
                    GridCacheInternal val0 = (GridCacheInternal)evt.getValue();
                    if (val0 instanceof GridCacheCountDownLatchValue) {
                        key = (GridCacheInternalKey)evt.getKey();
                        final GridCacheRemovable latch = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.get(key);
                        val = (GridCacheCountDownLatchValue)val0;
                        if (latch instanceof GridCacheCountDownLatchEx) {
                            final GridCacheCountDownLatchEx latch0 = (GridCacheCountDownLatchEx)latch;
                            latch0.onUpdate(((GridCacheCountDownLatchValue)val).get());
                            if (((GridCacheCountDownLatchValue)val).get() != 0 || !((GridCacheCountDownLatchValue)val).autoDelete()) continue;
                            DataStructuresProcessor.this.dsMap.remove(key);
                            IgniteInternalFuture<?> rmvFut = DataStructuresProcessor.this.ctx.closure().runLocalSafe(new GPR(){

                                @Override
                                public void run() {
                                    try {
                                        DataStructuresProcessor.this.removeCountDownLatch(latch0.name(), key.groupName());
                                    }
                                    catch (IgniteCheckedException e) {
                                        U.error(DataStructuresProcessor.this.log, "Failed to remove count down latch: " + latch0.name(), e);
                                    }
                                    finally {
                                        DataStructuresProcessor.this.ctx.cache().context().txContextReset();
                                    }
                                }
                            });
                            rmvFut.listen(new CI1<IgniteInternalFuture<?>>(){

                                @Override
                                public void apply(IgniteInternalFuture<?> f) {
                                    try {
                                        f.get();
                                    }
                                    catch (IgniteCheckedException e) {
                                        U.error(DataStructuresProcessor.this.log, "Failed to remove count down latch: " + latch0.name(), e);
                                    }
                                    latch.onRemoved();
                                }
                            });
                            continue;
                        }
                        if (latch == null) continue;
                        U.error(DataStructuresProcessor.this.log, "Failed to cast object [expected=" + IgniteCountDownLatch.class.getSimpleName() + ", actual=" + latch.getClass() + ", value=" + latch + ']');
                        continue;
                    }
                    if (val0 instanceof GridCacheSemaphoreState) {
                        key = (GridCacheInternalKey)evt.getKey();
                        GridCacheRemovable sem = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.get(key);
                        val = (GridCacheSemaphoreState)val0;
                        if (sem instanceof GridCacheSemaphoreEx) {
                            GridCacheSemaphoreEx semaphore0 = (GridCacheSemaphoreEx)sem;
                            semaphore0.onUpdate((GridCacheSemaphoreState)val);
                            continue;
                        }
                        if (sem == null) continue;
                        U.error(DataStructuresProcessor.this.log, "Failed to cast object [expected=" + IgniteSemaphore.class.getSimpleName() + ", actual=" + sem.getClass() + ", value=" + sem + ']');
                        continue;
                    }
                    if (!(val0 instanceof GridCacheLockState)) continue;
                    key = (GridCacheInternalKey)evt.getKey();
                    GridCacheRemovable reentrantLock = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.get(key);
                    val = (GridCacheLockState)val0;
                    if (reentrantLock instanceof GridCacheLockEx) {
                        GridCacheLockEx lock0 = (GridCacheLockEx)reentrantLock;
                        lock0.onUpdate((GridCacheLockState)val);
                        continue;
                    }
                    if (reentrantLock == null) continue;
                    U.error(DataStructuresProcessor.this.log, "Failed to cast object [expected=" + IgniteLock.class.getSimpleName() + ", actual=" + reentrantLock.getClass() + ", value=" + reentrantLock + ']');
                    continue;
                }
                assert (evt.getEventType() == EventType.REMOVED) : evt;
                GridCacheInternal key = (GridCacheInternal)evt.getKey();
                GridCacheRemovable obj = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.remove(key);
                if (obj == null) continue;
                obj.onRemoved();
            }
        }

        public String toString() {
            return S.toString(DataStructuresEntryListener.class, this);
        }
    }

    static class DataStructuresEntryFilter
    implements CacheEntryEventSerializableFilter<Object, Object> {
        private static final long serialVersionUID = 0L;

        DataStructuresEntryFilter() {
        }

        public boolean evaluate(CacheEntryEvent<?, ?> evt) throws CacheEntryListenerException {
            if (evt.getEventType() == EventType.CREATED || evt.getEventType() == EventType.UPDATED) {
                return evt.getValue() instanceof GridCacheCountDownLatchValue || evt.getValue() instanceof GridCacheSemaphoreState || evt.getValue() instanceof GridCacheLockState;
            }
            assert (evt.getEventType() == EventType.REMOVED) : evt;
            return true;
        }

        public String toString() {
            return S.toString(DataStructuresEntryFilter.class, this);
        }
    }
}

