/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.running;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.query.running.TrackableQuery;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public final class HeavyQueriesTracker {
    private static final long CHECK_PERIOD = 1000L;
    private static final long DFLT_FETCHED_SIZE_THRESHOLD = 100000L;
    public static final String LONG_QUERY_EXEC_MSG = "Query execution is too long";
    public static final String LONG_QUERY_FINISHED_MSG = "Long running query is finished";
    public static final String LONG_QUERY_ERROR_MSG = "Long running query is finished with error: ";
    public static final String BIG_RESULT_SET_MSG = "Query produced big result set.";
    private final ConcurrentHashMap<TrackableQuery, TimeoutChecker> qrys = new ConcurrentHashMap();
    private final GridWorker checkWorker;
    private final IgniteLogger log;
    private volatile long timeout;
    private volatile int timeoutMult = 2;
    private volatile long rsSizeThreshold = 100000L;
    private volatile int rsSizeThresholdMult = 2;

    public HeavyQueriesTracker(GridKernalContext ctx) {
        this.log = ctx.log(HeavyQueriesTracker.class);
        this.checkWorker = new GridWorker(ctx.igniteInstanceName(), "long-qry", this.log){

            @Override
            protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
                while (true) {
                    HeavyQueriesTracker.this.checkLongRunning();
                    U.sleep(1000L);
                }
            }
        };
        this.timeout = ctx.config().getSqlConfiguration().getLongQueryWarningTimeout();
        IgniteThread thread = new IgniteThread(this.checkWorker);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.checkWorker.cancel();
        this.qrys.clear();
    }

    public void startTracking(TrackableQuery qryInfo) {
        assert (qryInfo != null);
        long timeout0 = this.timeout;
        if (timeout0 > 0L) {
            this.qrys.put(qryInfo, new TimeoutChecker(timeout0, this.timeoutMult));
        }
    }

    public void stopTracking(TrackableQuery qryInfo, @Nullable Throwable err) {
        assert (qryInfo != null);
        this.qrys.remove(qryInfo);
        if (qryInfo.time() > this.timeout) {
            if (err == null) {
                LT.warn(this.log, LONG_QUERY_FINISHED_MSG + qryInfo.queryInfo(null));
            } else {
                LT.warn(this.log, LONG_QUERY_ERROR_MSG + err.getMessage() + qryInfo.queryInfo(null));
            }
        }
    }

    public ResultSetChecker resultSetChecker(TrackableQuery qryInfo) {
        return new ResultSetChecker(this.log, qryInfo, this.rsSizeThreshold, this.rsSizeThresholdMult);
    }

    private void checkLongRunning() {
        for (Map.Entry<TrackableQuery, TimeoutChecker> e : this.qrys.entrySet()) {
            TrackableQuery qinfo = e.getKey();
            if (!e.getValue().checkTimeout(qinfo.time())) continue;
            LT.warn(this.log, LONG_QUERY_EXEC_MSG + qinfo.queryInfo(null));
            if (e.getValue().timeoutMult > 1) continue;
            this.qrys.remove(qinfo);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getTimeoutMultiplier() {
        return this.timeoutMult;
    }

    public void setTimeoutMultiplier(int timeoutMult) {
        this.timeoutMult = timeoutMult;
    }

    public long getResultSetSizeThreshold() {
        return this.rsSizeThreshold;
    }

    public void setResultSetSizeThreshold(long rsSizeThreshold) {
        this.rsSizeThreshold = rsSizeThreshold;
    }

    public int getResultSetSizeThresholdMultiplier() {
        return this.rsSizeThresholdMult;
    }

    public void setResultSetSizeThresholdMultiplier(int rsSizeThresholdMult) {
        this.rsSizeThresholdMult = rsSizeThresholdMult <= 1 ? 1 : rsSizeThresholdMult;
    }

    public static class ResultSetChecker {
        private final IgniteLogger log;
        private final TrackableQuery qryInfo;
        private long threshold;
        private final int thresholdMult;
        private long fetchedSize;
        private boolean bigResults;

        private ResultSetChecker(IgniteLogger log, TrackableQuery qryInfo, long threshold, int thresholdMult) {
            this.log = log;
            this.qryInfo = qryInfo;
            this.threshold = threshold;
            this.thresholdMult = thresholdMult;
        }

        public void checkOnFetchNext() {
            ++this.fetchedSize;
            if (this.threshold > 0L && this.fetchedSize >= this.threshold) {
                LT.warn(this.log, HeavyQueriesTracker.BIG_RESULT_SET_MSG + this.qryInfo.queryInfo("fetched=" + this.fetchedSize));
                this.threshold = this.thresholdMult > 1 ? (this.threshold *= (long)this.thresholdMult) : 0L;
                this.bigResults = true;
            }
        }

        public void checkOnClose() {
            if (this.bigResults) {
                LT.warn(this.log, HeavyQueriesTracker.BIG_RESULT_SET_MSG + this.qryInfo.queryInfo("fetched=" + this.fetchedSize));
            }
        }

        public long fetchedSize() {
            return this.fetchedSize;
        }
    }

    private static class TimeoutChecker {
        private long timeout;
        private final int timeoutMult;

        public TimeoutChecker(long timeout, int timeoutMult) {
            this.timeout = timeout;
            this.timeoutMult = timeoutMult;
        }

        public boolean checkTimeout(long time) {
            if (time > this.timeout) {
                if (this.timeoutMult > 1) {
                    this.timeout *= (long)this.timeoutMult;
                }
                return true;
            }
            return false;
        }
    }
}

