/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.java;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.java.JavaLogger;
import org.jetbrains.annotations.Nullable;

public final class JavaLoggerFileHandler
extends StreamHandler {
    private static final LogManager manager = LogManager.getLogManager();
    private volatile FileHandler delegate;

    @Override
    public void publish(LogRecord record) {
        FileHandler delegate0 = this.delegate;
        if (delegate0 != null) {
            delegate0.publish(record);
        }
    }

    @Override
    public void flush() {
        FileHandler delegate0 = this.delegate;
        if (delegate0 != null) {
            delegate0.flush();
        }
    }

    @Override
    public void close() throws SecurityException {
        FileHandler delegate0 = this.delegate;
        if (delegate0 != null) {
            delegate0.close();
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        FileHandler delegate0 = this.delegate;
        return delegate0 != null && delegate0.isLoggable(record);
    }

    public void nodeId(UUID nodeId, String workDir) throws IgniteCheckedException, IOException {
        this.nodeId(null, nodeId, workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeId(@Nullable String app, @Nullable UUID nodeId, String workDir) throws IgniteCheckedException, IOException {
        FileHandler delegate0;
        int cnt;
        if (this.delegate != null) {
            return;
        }
        String clsName = this.getClass().getName();
        String ptrn = manager.getProperty(clsName + ".pattern");
        if (ptrn == null) {
            ptrn = "%{app}%{id8}.%g.log";
        }
        String fileName = ptrn.replace("%{app}", app != null ? app : "ignite").replace("%{id8}", nodeId != null ? "-" + U.id8(nodeId) : "");
        ptrn = new File(JavaLoggerFileHandler.logDirectory(workDir), fileName).getAbsolutePath();
        int limit = this.getIntProperty(clsName + ".limit", 0);
        if (limit < 0) {
            limit = 0;
        }
        if ((cnt = this.getIntProperty(clsName + ".count", 1)) <= 0) {
            cnt = 1;
        }
        boolean append = this.getBooleanProperty(clsName + ".append", false);
        JavaLoggerFileHandler javaLoggerFileHandler = this;
        synchronized (javaLoggerFileHandler) {
            if (this.delegate != null) {
                return;
            }
            this.delegate = delegate0 = new FileHandler(ptrn, limit, cnt, append);
        }
        delegate0.setLevel(this.getLevel());
        delegate0.setFormatter(this.getFormatter());
        delegate0.setEncoding(this.getEncoding());
        delegate0.setFilter(this.getFilter());
        delegate0.setErrorManager(this.getErrorManager());
    }

    @Nullable
    public String fileName() {
        return JavaLogger.fileName(this.delegate);
    }

    public static File logDirectory(String workDir) throws IgniteCheckedException {
        return !F.isEmpty(U.IGNITE_LOG_DIR) ? new File(U.IGNITE_LOG_DIR) : U.resolveWorkDirectory(workDir, "log", false);
    }

    private int getIntProperty(String name, int dfltVal) {
        String val = manager.getProperty(name);
        if (val == null) {
            return dfltVal;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return dfltVal;
        }
    }

    private boolean getBooleanProperty(String name, boolean dfltVal) {
        String val = manager.getProperty(name);
        if (val == null) {
            return dfltVal;
        }
        if ("true".equals(val = val.toLowerCase()) || "1".equals(val)) {
            return true;
        }
        if ("false".equals(val) || "0".equals(val)) {
            return false;
        }
        return dfltVal;
    }

    public String toString() {
        return S.toString(JavaLoggerFileHandler.class, this);
    }
}

