/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteTooManyOpenFilesException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.IgniteExceptionRegistry;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.nio.GridNioRecoveryDescriptor;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridTcpNioCommunicationClient;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.spi.communication.tcp.AttributeNames;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationTcpUtils;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionClientPool;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionKey;
import org.apache.ignite.spi.communication.tcp.internal.DisconnectedSessionInfo;
import org.apache.ignite.spi.communication.tcp.internal.GridNioServerWrapper;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConfiguration;
import org.apache.ignite.spi.communication.tcp.messages.RecoveryLastReceivedMessage;

public class CommunicationWorker
extends GridWorker {
    public static final String WORKER_NAME = "tcp-comm-worker";
    private final TcpCommunicationConfiguration cfg;
    private final AttributeNames attrs;
    private final BlockingQueue<DisconnectedSessionInfo> q = new LinkedBlockingQueue<DisconnectedSessionInfo>();
    private final ConnectionClientPool clientPool;
    private final Supplier<FailureProcessor> failureProcessorSupplier;
    private final Function<UUID, ClusterNode> nodeGetter;
    private final Function<UUID, Boolean> pingNode;
    private final Supplier<IgniteExceptionRegistry> eRegistrySupplier;
    private final GridNioServerWrapper nioSrvWrapper;
    private final String spiName;
    private volatile boolean stopping = false;

    public CommunicationWorker(String igniteInstanceName, IgniteLogger log, TcpCommunicationConfiguration cfg, AttributeNames attrs, ConnectionClientPool clientPool, Supplier<FailureProcessor> failureProcessorSupplier, Function<UUID, ClusterNode> nodeGetter, Function<UUID, Boolean> pingNode, Supplier<IgniteExceptionRegistry> eRegistrySupplier, GridNioServerWrapper nioSrvWrapper, WorkersRegistry workersRegistry, String spiName) {
        super(igniteInstanceName, WORKER_NAME, log, workersRegistry);
        this.cfg = cfg;
        this.attrs = attrs;
        this.clientPool = clientPool;
        this.failureProcessorSupplier = failureProcessorSupplier;
        this.nodeGetter = nodeGetter;
        this.pingNode = pingNode;
        this.eRegistrySupplier = eRegistrySupplier;
        this.nioSrvWrapper = nioSrvWrapper;
        this.spiName = spiName;
    }

    public void addProcessDisconnectRequest(DisconnectedSessionInfo sesInfo) {
        boolean add = this.q.add(sesInfo);
        assert (add);
    }

    public void stop() {
        this.stopping = true;
    }

    @Override
    protected void body() throws InterruptedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Tcp communication worker has been started.");
        }
        Throwable err = null;
        try {
            while (!this.isCancelled()) {
                DisconnectedSessionInfo disconnectData;
                this.blockingSectionBegin();
                try {
                    disconnectData = this.q.poll(this.cfg.idleConnectionTimeout(), TimeUnit.MILLISECONDS);
                }
                finally {
                    this.blockingSectionEnd();
                }
                if (disconnectData != null) {
                    this.processDisconnect(disconnectData);
                } else {
                    this.processIdle();
                }
                this.onIdle();
            }
        }
        catch (Throwable t) {
            if (!(t instanceof InterruptedException)) {
                err = t;
            }
            throw t;
        }
        finally {
            FailureProcessor failureProcessor = this.failureProcessorSupplier.get();
            if (failureProcessor != null) {
                if (err == null && !this.stopping) {
                    err = new IllegalStateException("Thread  " + this.spiName + " is terminated unexpectedly.");
                }
                if (err instanceof OutOfMemoryError) {
                    failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    failureProcessor.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }
    }

    private void processIdle() {
        this.cleanupRecovery();
        for (Map.Entry<UUID, GridCommunicationClient[]> entry : this.clientPool.entrySet()) {
            UUID nodeId = entry.getKey();
            for (GridCommunicationClient client : entry.getValue()) {
                if (client == null) continue;
                ClusterNode node = this.nodeGetter.apply(nodeId);
                if (node == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Forcing close of non-existent node connection: " + nodeId);
                    }
                    client.forceClose();
                    this.clientPool.removeNodeClient(nodeId, client);
                    continue;
                }
                GridNioRecoveryDescriptor recovery = null;
                if (!(this.cfg.usePairedConnections() && CommunicationTcpUtils.usePairedConnections(node, this.attrs.pairedConnection()) || !(client instanceof GridTcpNioCommunicationClient) || (recovery = (GridNioRecoveryDescriptor)this.nioSrvWrapper.recoveryDescs().get(new ConnectionKey(node.id(), client.connectionIndex(), -1L))) == null || recovery.lastAcknowledged() == recovery.received())) {
                    RecoveryLastReceivedMessage msg = new RecoveryLastReceivedMessage(recovery.received());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Send recovery acknowledgement on timeout [rmtNode=" + nodeId + ", rcvCnt=" + msg.received() + ']');
                    }
                    try {
                        this.nioSrvWrapper.nio().sendSystem(((GridTcpNioCommunicationClient)client).session(), msg);
                        recovery.lastAcknowledged(msg.received());
                    }
                    catch (IgniteCheckedException err) {
                        U.error(this.log, "Failed to send message: " + err, err);
                    }
                    continue;
                }
                long idleTime = client.getIdleTime();
                if (idleTime < this.cfg.idleConnectionTimeout()) continue;
                if (recovery == null && this.cfg.usePairedConnections() && CommunicationTcpUtils.usePairedConnections(node, this.attrs.pairedConnection())) {
                    recovery = (GridNioRecoveryDescriptor)this.nioSrvWrapper.outRecDescs().get(new ConnectionKey(node.id(), client.connectionIndex(), -1L));
                }
                if (recovery != null && recovery.nodeAlive(this.nodeGetter.apply(nodeId)) && !recovery.messagesRequests().isEmpty()) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Node connection is idle, but there are unacknowledged messages, will wait: " + nodeId);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Closing idle node connection: " + nodeId);
                }
                if (!client.close() && !client.closed()) continue;
                this.clientPool.removeNodeClient(nodeId, client);
            }
        }
        for (GridNioSession gridNioSession : this.nioSrvWrapper.nio().sessions()) {
            GridNioRecoveryDescriptor recovery = gridNioSession.inRecoveryDescriptor();
            if (recovery == null || !this.cfg.usePairedConnections() || !CommunicationTcpUtils.usePairedConnections(recovery.node(), this.attrs.pairedConnection())) continue;
            assert (gridNioSession.accepted()) : gridNioSession;
            this.sendAckOnTimeout(recovery, gridNioSession);
        }
    }

    private void sendAckOnTimeout(GridNioRecoveryDescriptor recovery, GridNioSession ses) {
        if (recovery != null && recovery.lastAcknowledged() != recovery.received()) {
            RecoveryLastReceivedMessage msg = new RecoveryLastReceivedMessage(recovery.received());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send recovery acknowledgement on timeout [rmtNode=" + recovery.node().id() + ", rcvCnt=" + msg.received() + ", lastAcked=" + recovery.lastAcknowledged() + ']');
            }
            try {
                this.nioSrvWrapper.nio().sendSystem(ses, msg);
                recovery.lastAcknowledged(msg.received());
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send message: " + e, e);
            }
        }
    }

    private void cleanupRecovery() {
        this.cleanupRecovery(this.nioSrvWrapper.recoveryDescs());
        this.cleanupRecovery(this.nioSrvWrapper.inRecDescs());
        this.cleanupRecovery(this.nioSrvWrapper.outRecDescs());
    }

    private void cleanupRecovery(ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> recoveryDescs) {
        GridNioRecoveryDescriptor recoveryDesc;
        HashSet left = null;
        for (Map.Entry e : recoveryDescs.entrySet()) {
            if (left != null && left.contains(e.getKey()) || (recoveryDesc = (GridNioRecoveryDescriptor)e.getValue()).nodeAlive(this.nodeGetter.apply(((ConnectionKey)e.getKey()).nodeId()))) continue;
            if (left == null) {
                left = new HashSet();
            }
            left.add(e.getKey());
        }
        if (left != null) {
            assert (!left.isEmpty());
            for (ConnectionKey id : left) {
                recoveryDesc = (GridNioRecoveryDescriptor)recoveryDescs.get(id);
                if (recoveryDesc == null || !recoveryDesc.onNodeLeft()) continue;
                recoveryDescs.remove(id, recoveryDesc);
            }
        }
    }

    private void processDisconnect(DisconnectedSessionInfo sesInfo) {
        block13: {
            ClusterNode node;
            GridNioRecoveryDescriptor recoveryDesc = sesInfo.recoveryDescription();
            if (!recoveryDesc.nodeAlive(this.nodeGetter.apply((node = recoveryDesc.node()).id()))) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Recovery reconnect [rmtNode=" + recoveryDesc.node().id() + ']');
                }
                GridCommunicationClient client = this.clientPool.reserveClient(node, sesInfo.connectionIndex());
                client.release();
            }
            catch (ClusterTopologyCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Recovery reconnect failed, node stopping [rmtNode=" + recoveryDesc.node().id() + ']');
                }
            }
            catch (IgniteTooManyOpenFilesException e) {
                this.eRegistrySupplier.get().onException(e.getMessage(), e);
                throw e;
            }
            catch (IgniteCheckedException | IgniteException e) {
                try {
                    if (recoveryDesc.nodeAlive(this.nodeGetter.apply(node.id())) && this.pingNode.apply(node.id()).booleanValue()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Recovery reconnect failed, will retry [rmtNode=" + recoveryDesc.node().id() + ", err=" + e + ']');
                        }
                        this.addProcessDisconnectRequest(sesInfo);
                    } else {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Recovery reconnect failed, node left [rmtNode=" + recoveryDesc.node().id() + ", err=" + e + ']');
                        }
                        this.eRegistrySupplier.get().onException("Recovery reconnect failed, node left [rmtNode=" + recoveryDesc.node().id() + "]", e);
                    }
                }
                catch (IgniteClientDisconnectedException ignored) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug("Failed to ping node, client disconnected.");
                }
            }
        }
    }
}

