/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.prometheus.PrometheusErrorCode;
import io.trino.plugin.prometheus.PrometheusMetricResult;
import io.trino.plugin.prometheus.PrometheusTimeSeriesValue;
import io.trino.plugin.prometheus.PrometheusTimeSeriesValueArray;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PrometheusQueryResponseParse {
    private boolean status;
    private String resultType;
    private String result;
    private List<PrometheusMetricResult> results;

    public PrometheusQueryResponseParse(InputStream response) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        JsonParser parser = JsonUtils.jsonFactory().createParser(response);
        while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            if (JsonToken.FIELD_NAME.equals((Object)jsonToken) && parser.currentName().equals("status")) {
                parser.nextToken();
                if (parser.getValueAsString().equals("success")) {
                    this.status = true;
                    while (!parser.isClosed()) {
                        parser.nextToken();
                        if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                        if (parser.currentName().equals("resultType")) {
                            parser.nextToken();
                            this.resultType = parser.getValueAsString();
                        }
                        if (!parser.currentName().equals("result")) continue;
                        parser.nextToken();
                        ArrayNode node = (ArrayNode)mapper.readTree(parser);
                        this.result = node.toString();
                        break;
                    }
                } else {
                    String parsedStatus = parser.getValueAsString();
                    parser.nextToken();
                    parser.nextToken();
                    String errorType = parser.getValueAsString();
                    parser.nextToken();
                    parser.nextToken();
                    String error = parser.getValueAsString();
                    throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_PARSE_ERROR, "Unable to parse Prometheus response: " + parsedStatus + " " + errorType + " " + error);
                }
            }
            if (this.result == null) continue;
            break;
        }
        if (this.result != null && this.resultType != null) {
            switch (this.resultType) {
                case "matrix": 
                case "vector": {
                    this.results = (List)mapper.readValue(this.result, (TypeReference)new TypeReference<List<PrometheusMetricResult>>(this){});
                    break;
                }
                case "scalar": 
                case "string": {
                    PrometheusTimeSeriesValue stringOrScalarResult = (PrometheusTimeSeriesValue)mapper.readValue(this.result, (TypeReference)new TypeReference<PrometheusTimeSeriesValue>(this){});
                    HashMap<String, String> madeUpMetricHeader = new HashMap<String, String>();
                    madeUpMetricHeader.put("__name__", this.resultType);
                    PrometheusTimeSeriesValueArray timeSeriesValues = new PrometheusTimeSeriesValueArray(Collections.singletonList(stringOrScalarResult));
                    this.results = Collections.singletonList(new PrometheusMetricResult(madeUpMetricHeader, timeSeriesValues));
                }
            }
        }
    }

    public List<PrometheusMetricResult> getResults() {
        return this.results;
    }

    public boolean getStatus() {
        return this.status;
    }
}

