/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.prometheus.PrometheusConnectorConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public final class PrometheusSessionProperties
implements SessionPropertiesProvider {
    private static final String QUERY_CHUNK_SIZE_DURATION = "query_chunk_size_duration";
    private static final String MAX_QUERY_RANGE_DURATION = "max_query_range_duration";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public PrometheusSessionProperties(PrometheusConnectorConfig connectorConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadataUtil.durationProperty((String)QUERY_CHUNK_SIZE_DURATION, (String)"The duration of each query to Prometheus", (Duration)connectorConfig.getQueryChunkSizeDuration(), (boolean)false)).add((Object)PropertyMetadataUtil.durationProperty((String)MAX_QUERY_RANGE_DURATION, (String)"Width of overall query to Prometheus, will be divided into query_chunk_size_duration queries", (Duration)connectorConfig.getMaxQueryRangeDuration(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static Duration getQueryChunkSize(ConnectorSession session) {
        return (Duration)session.getProperty(QUERY_CHUNK_SIZE_DURATION, Duration.class);
    }

    public static Duration getMaxQueryRange(ConnectorSession session) {
        return (Duration)session.getProperty(MAX_QUERY_RANGE_DURATION, Duration.class);
    }
}

