/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;

public record PrometheusTableHandle(String schemaName, String tableName, Optional<TupleDomain<ColumnHandle>> predicate) implements ConnectorTableHandle
{
    public PrometheusTableHandle {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(predicate, "predicate is null");
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public PrometheusTableHandle withPredicate(TupleDomain<ColumnHandle> predicate) {
        return new PrometheusTableHandle(this.schemaName, this.tableName, Optional.of(predicate));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrometheusTableHandle other = (PrometheusTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    @Override
    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

