/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.trino.plugin.prometheus.PrometheusErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.time.Instant;

public class PrometheusTimestampDeserializer
extends JsonDeserializer<Instant> {
    public Instant deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String timestamp = jsonParser.getText().trim();
        try {
            return PrometheusTimestampDeserializer.decimalEpochTimestampToSQLTimestamp(timestamp);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "unable to deserialize timestamp: " + e.getMessage());
        }
    }

    static Instant decimalEpochTimestampToSQLTimestamp(String timestamp) {
        long promTimestampMillis = (long)(Double.parseDouble(timestamp) * 1000.0);
        return Instant.ofEpochMilli(promTimestampMillis);
    }
}

