/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.net.ssl.SSLContext;
import javax.sql.XAConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.util.OpaqueString;

public abstract class UCPXAConnectionBuilderImpl
implements UCPXAConnectionBuilder {
    private volatile String user = null;
    private volatile OpaqueString password = null;
    protected volatile Properties labels = null;
    private volatile String serviceName = null;
    protected volatile int proxyType = -1;
    protected volatile Properties proxyProperties = null;
    protected volatile OracleShardingKey shardingKey = null;
    protected volatile OracleShardingKey superShardingKey = null;
    private volatile Properties pdbRoles = null;
    private volatile SSLContext sslContext = null;
    private volatile PoolDataSource.HostnameResolver hostnameResolver = null;
    private volatile Boolean readOnlyInstanceAllowed = null;
    private volatile Duration connectionWaitDuration = null;
    protected Executor executor = ForkJoinPool.commonPool();

    void updateMissing(PoolXADataSourceImpl pds) {
        if (Objects.isNull(this.user)) {
            this.user = pds.getUser();
        }
        if (Objects.isNull(this.password)) {
            this.password = pds.getPasswordInternal();
        }
        if (Objects.isNull(this.serviceName)) {
            this.serviceName = pds.getServiceName();
        }
        if (Objects.isNull(this.pdbRoles)) {
            this.pdbRoles = pds.getPdbRoles();
        }
        if (Objects.isNull(this.sslContext)) {
            this.sslContext = pds.getSSLContext();
        }
        if (Objects.isNull(this.hostnameResolver)) {
            this.hostnameResolver = pds.getHostnameResolver();
        }
        if (Objects.isNull(this.readOnlyInstanceAllowed)) {
            this.readOnlyInstanceAllowed = new Boolean(pds.isReadOnlyInstanceAllowed());
        }
        if (Objects.isNull(this.connectionWaitDuration)) {
            this.connectionWaitDuration = pds.getConnectionWaitDuration();
        }
    }

    @Override
    public UCPXAConnectionBuilder user(String user) {
        this.user = user;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder password(@Blind String password) {
        this.password = OpaqueString.newOpaqueString(password);
        return this;
    }

    UCPXAConnectionBuilder internalPassword(OpaqueString password) {
        this.password = password;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder labels(Properties labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder proxyProperties(int proxyType, Properties proxyProperties) {
        this.proxyType = proxyType;
        this.proxyProperties = proxyProperties;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder shardingKey(OracleShardingKey shardingKey) {
        this.shardingKey = shardingKey;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder superShardingKey(OracleShardingKey superShardingKey) {
        if (superShardingKey != null) {
            ((OracleShardingKeyImpl)superShardingKey).markSuperShardingKey(true);
        }
        this.superShardingKey = superShardingKey;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder pdbRoles(Properties pdbRoles) {
        this.pdbRoles = pdbRoles;
        return this;
    }

    UCPXAConnectionBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    UCPXAConnectionBuilder hostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
        this.hostnameResolver = hostnameResolver;
        return this;
    }

    UCPXAConnectionBuilder readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.readOnlyInstanceAllowed = readOnlyInstanceAllowed;
        return this;
    }

    UCPXAConnectionBuilder copyFrom(UCPConnectionBuilderImpl ucpConnBldr) {
        this.password = ucpConnBldr.getPassword();
        this.user(ucpConnBldr.getUser()).labels(ucpConnBldr.labels).proxyProperties(ucpConnBldr.proxyType, ucpConnBldr.proxyProperties).serviceName(ucpConnBldr.getServiceName()).shardingKey(ucpConnBldr.shardingKey).superShardingKey(ucpConnBldr.superShardingKey).pdbRoles(ucpConnBldr.getPdbRoles());
        return this;
    }

    @Override
    public abstract XAConnection build() throws SQLException;

    public String getUser() {
        return this.user;
    }

    OpaqueString getPassword() {
        return this.password;
    }

    String getServiceName() {
        return this.serviceName;
    }

    Properties getPdbRoles() {
        return this.pdbRoles;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    PoolDataSource.HostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }

    Boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }

    @Override
    public UCPXAConnectionBuilder executor(Executor executor) {
        if (Objects.isNull(executor)) {
            throw new IllegalArgumentException("executor should not be null");
        }
        this.executor = executor;
        return this;
    }

    @Override
    @Deprecated
    public UCPXAConnectionBuilder connectionWaitTimeout(int connectionWaitTimeout) {
        if (connectionWaitTimeout < 0) {
            throw new IllegalArgumentException("connection wait timeout should be >= 0");
        }
        this.connectionWaitDuration = Duration.ofSeconds(connectionWaitTimeout);
        return this;
    }

    @Deprecated
    Integer getConnectionWaitTimeout() {
        return Math.toIntExact(this.connectionWaitDuration.getSeconds());
    }

    @Override
    public UCPXAConnectionBuilder connectionWaitDuration(Duration connectionWaitDuration) {
        Objects.requireNonNull(connectionWaitDuration);
        if (connectionWaitDuration.isNegative()) {
            throw new IllegalArgumentException("connection wait duration should be 0 or positive");
        }
        this.connectionWaitDuration = connectionWaitDuration;
        return this;
    }

    Duration getConnectionWaitDuration() {
        return this.connectionWaitDuration;
    }
}

