/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoTelemetry;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.mongodb.DefaultMongoMetadataFactory;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.plugin.mongodb.MongoClientSettingConfigurator;
import io.trino.plugin.mongodb.MongoConnector;
import io.trino.plugin.mongodb.MongoMetadataFactory;
import io.trino.plugin.mongodb.MongoPageSinkProvider;
import io.trino.plugin.mongodb.MongoPageSourceProvider;
import io.trino.plugin.mongodb.MongoServerDetailsProvider;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoSessionProperties;
import io.trino.plugin.mongodb.MongoSplitManager;
import io.trino.plugin.mongodb.MongoTlsModule;
import io.trino.plugin.mongodb.MongoTransactionManager;
import io.trino.plugin.mongodb.SessionBasedMongoServerDetailsProvider;
import io.trino.plugin.mongodb.ptf.Query;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.type.TypeManager;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MongoClientModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        binder.bind(MongoConnector.class).in(Scopes.SINGLETON);
        binder.bind(MongoTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(MongoSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSinkProvider.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(MongoSessionProperties.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, MongoMetadataFactory.class).setDefault().to(DefaultMongoMetadataFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MongoClientConfig.class);
        Multibinder.newSetBinder((Binder)binder, MongoClientSettingConfigurator.class);
        this.install(ConditionalModule.conditionalModule(MongoClientConfig.class, MongoClientConfig::getTlsEnabled, (Module)new MongoTlsModule()));
        this.install(ConditionalModule.conditionalModule(MongoClientConfig.class, MongoClientConfig::isAllowLocalScheduling, internalBinder -> internalBinder.bind(MongoServerDetailsProvider.class).toInstance(ImmutableList::of), internalBinder -> internalBinder.bind(MongoServerDetailsProvider.class).to(SessionBasedMongoServerDetailsProvider.class).in(Scopes.SINGLETON)));
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    public static MongoSession createMongoSession(TypeManager typeManager, MongoClientConfig config, Set<MongoClientSettingConfigurator> configurators, OpenTelemetry openTelemetry) {
        MongoClientSettings.Builder options = MongoClientSettings.builder();
        configurators.forEach(configurator -> configurator.configure(options));
        options.addCommandListener(MongoTelemetry.builder((OpenTelemetry)openTelemetry).build().newCommandListener());
        MongoClient client = MongoClients.create((MongoClientSettings)options.build());
        return new MongoSession(typeManager, client, config);
    }

    @ProvidesIntoSet
    @Singleton
    public MongoClientSettingConfigurator defaultConfigurator(MongoClientConfig config) {
        return options -> {
            options.writeConcern(config.getWriteConcern().getWriteConcern()).readPreference(config.getReadPreference().getReadPreference()).applyToConnectionPoolSettings(builder -> builder.maxConnectionIdleTime((long)config.getMaxConnectionIdleTime(), TimeUnit.MILLISECONDS).maxWaitTime((long)config.getMaxWaitTime(), TimeUnit.MILLISECONDS).minSize(config.getMinConnectionsPerHost()).maxSize(config.getConnectionsPerHost())).applyToSocketSettings(builder -> builder.connectTimeout((long)config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)config.getSocketTimeout(), TimeUnit.MILLISECONDS));
            if (config.getRequiredReplicaSetName() != null) {
                options.applyToClusterSettings(builder -> builder.requiredReplicaSetName(config.getRequiredReplicaSetName()));
            }
            options.applyConnectionString(new ConnectionString(config.getConnectionUrl()));
        };
    }
}

