/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bson.Document;

public record MongoColumnHandle(String baseName, List<String> dereferenceNames, Type type, boolean hidden, boolean dbRefField, Optional<String> comment) implements ColumnHandle
{
    public MongoColumnHandle {
        Objects.requireNonNull(baseName, "baseName is null");
        dereferenceNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(dereferenceNames, "dereferenceNames is null"));
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(comment, "comment is null");
    }

    public ColumnMetadata toColumnMetadata() {
        return ColumnMetadata.builder().setName(this.getQualifiedName()).setType(this.type).setHidden(this.hidden).setComment(this.comment).build();
    }

    @JsonIgnore
    public String getQualifiedName() {
        return Joiner.on((char)'.').join((Iterable)ImmutableList.builder().add((Object)this.baseName).addAll(this.dereferenceNames).build());
    }

    @JsonIgnore
    public boolean isBaseColumn() {
        return this.dereferenceNames.isEmpty();
    }

    public Document getDocument() {
        return new Document().append("name", (Object)this.getQualifiedName()).append("type", (Object)this.type.getTypeSignature().toString()).append("hidden", (Object)this.hidden).append("dbRefField", (Object)this.dbRefField).append("comment", this.comment.orElse(null));
    }

    @Override
    public String toString() {
        return this.getQualifiedName() + ":" + String.valueOf(this.type);
    }
}

