/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record MongoOutputTableHandle(RemoteTableName remoteTableName, List<MongoColumnHandle> columns, Optional<String> temporaryTableName, Optional<String> pageSinkIdColumnName) implements ConnectorOutputTableHandle
{
    @JsonCreator
    public MongoOutputTableHandle {
        Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        Objects.requireNonNull(temporaryTableName, "temporaryTableName is null");
        Objects.requireNonNull(pageSinkIdColumnName, "pageSinkIdColumnName is null");
        Preconditions.checkArgument((temporaryTableName.isPresent() == pageSinkIdColumnName.isPresent() ? 1 : 0) != 0, (Object)"temporaryTableName.isPresent is not equal to pageSinkIdColumnName.isPresent");
    }

    @JsonIgnore
    public Optional<RemoteTableName> getTemporaryRemoteTableName() {
        return this.temporaryTableName.map(tableName -> new RemoteTableName(this.remoteTableName.databaseName(), (String)tableName));
    }
}

