/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public final class MongoSessionProperties
implements SessionPropertiesProvider {
    private static final String PROJECTION_PUSHDOWN_ENABLED = "projection_pushdown_enabled";
    public static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public MongoSessionProperties(MongoClientConfig mongoConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)PROJECTION_PUSHDOWN_ENABLED, (String)"Read only required fields from a row type", (Boolean)mongoConfig.isProjectionPushdownEnabled(), (boolean)false)).add((Object)PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters", (Duration)mongoConfig.getDynamicFilteringWaitTimeout(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isProjectionPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PROJECTION_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }
}

