/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.mongodb.MongoServerDetailsProvider;
import io.trino.plugin.mongodb.MongoSessionProperties;
import io.trino.plugin.mongodb.MongoSplit;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class MongoSplitManager
implements ConnectorSplitManager {
    private static final ConnectorSplitSource.ConnectorSplitBatch EMPTY_BATCH = new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), false);
    private final MongoServerDetailsProvider serverDetailsProvider;

    @Inject
    public MongoSplitManager(MongoServerDetailsProvider serverDetailsProvider) {
        this.serverDetailsProvider = Objects.requireNonNull(serverDetailsProvider, "serverDetailsProvider is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        MongoSplit split = new MongoSplit(this.serverDetailsProvider.getServerAddress());
        return new MongoSplitSource(session, dynamicFilter, (ConnectorSplitSource)new FixedSplitSource((ConnectorSplit)split));
    }

    private static class MongoSplitSource
    implements ConnectorSplitSource {
        private final DynamicFilter dynamicFilter;
        private final long startNanos;
        private final long dynamicFilteringTimeoutNanos;
        private final ConnectorSplitSource delegateSplitSource;

        public MongoSplitSource(ConnectorSession session, DynamicFilter dynamicFilter, ConnectorSplitSource delegateSplitSource) {
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
            this.dynamicFilteringTimeoutNanos = (long)MongoSessionProperties.getDynamicFilteringWaitTimeout(session).getValue(TimeUnit.NANOSECONDS);
            this.startNanos = System.nanoTime();
            this.delegateSplitSource = Objects.requireNonNull(delegateSplitSource, "delegateSplitSource is null");
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            long remainingTimeoutNanos = this.getRemainingTimeoutNanos();
            if (remainingTimeoutNanos > 0L && this.dynamicFilter.isAwaitable()) {
                return ((CompletableFuture)this.dynamicFilter.isBlocked().thenApply(object -> EMPTY_BATCH)).completeOnTimeout(EMPTY_BATCH, remainingTimeoutNanos, TimeUnit.NANOSECONDS);
            }
            return this.delegateSplitSource.getNextBatch(maxSize);
        }

        public void close() {
            this.delegateSplitSource.close();
        }

        public boolean isFinished() {
            if (this.getRemainingTimeoutNanos() > 0L && this.dynamicFilter.isAwaitable()) {
                return false;
            }
            return this.delegateSplitSource.isFinished();
        }

        private long getRemainingTimeoutNanos() {
            return this.dynamicFilteringTimeoutNanos - (System.nanoTime() - this.startNanos);
        }
    }
}

