/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;

public record MongoTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName, Optional<String> filter, TupleDomain<ColumnHandle> constraint, Set<MongoColumnHandle> projectedColumns, OptionalInt limit) implements ConnectorTableHandle
{
    public MongoTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName, Optional<String> filter) {
        this(schemaTableName, remoteTableName, filter, (TupleDomain<ColumnHandle>)TupleDomain.all(), (Set<MongoColumnHandle>)ImmutableSet.of(), OptionalInt.empty());
    }

    public MongoTableHandle {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(constraint, "constraint is null");
        projectedColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(projectedColumns, "projectedColumns is null"));
        Objects.requireNonNull(limit, "limit is null");
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.remoteTableName);
        this.filter.ifPresent(value -> builder.append(" filter=").append((String)value));
        if (this.constraint.isNone()) {
            builder.append(" constraint=FALSE");
        } else if (!this.constraint.isAll()) {
            builder.append(" constraint on ");
            builder.append(((Map)this.constraint.getDomains().orElseThrow()).keySet().stream().map(columnHandle -> ((MongoColumnHandle)columnHandle).baseName()).collect(Collectors.joining(", ", "[", "]")));
        }
        if (!this.projectedColumns.isEmpty()) {
            builder.append(" columns=").append(this.projectedColumns);
        }
        this.limit.ifPresent(value -> builder.append(" limit=").append(value));
        return builder.toString();
    }

    public MongoTableHandle withProjectedColumns(Set<MongoColumnHandle> projectedColumns) {
        return new MongoTableHandle(this.schemaTableName, this.remoteTableName, this.filter, this.constraint, projectedColumns, this.limit);
    }

    public MongoTableHandle withConstraint(TupleDomain<ColumnHandle> constraint) {
        return new MongoTableHandle(this.schemaTableName, this.remoteTableName, this.filter, constraint, this.projectedColumns, this.limit);
    }
}

