/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.slice.Slice;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoMetadata;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.plugin.mongodb.MongoTransactionManager;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bson.Document;
import org.bson.json.JsonParseException;

public class Query
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "query";
    private final MongoTransactionManager transactionManager;

    @Inject
    public Query(MongoTransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public ConnectorTableFunction get() {
        return new QueryFunction(this.transactionManager);
    }

    public static Document parseFilter(String filter) {
        try {
            return Document.parse((String)filter);
        }
        catch (JsonParseException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Can't parse 'filter' argument as json", (Throwable)e);
        }
    }

    public static class QueryFunction
    extends AbstractConnectorTableFunction {
        private final MongoTransactionManager transactionManager;

        public QueryFunction(MongoTransactionManager transactionManager) {
            super(Query.SCHEMA_NAME, Query.NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name("DATABASE").type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name("COLLECTION").type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name("FILTER").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            MongoMetadata metadata = this.transactionManager.getMetadata(transaction);
            String database = ((Slice)((ScalarArgument)arguments.get("DATABASE")).getValue()).toStringUtf8();
            String collection = ((Slice)((ScalarArgument)arguments.get("COLLECTION")).getValue()).toStringUtf8();
            String filter = ((Slice)((ScalarArgument)arguments.get("FILTER")).getValue()).toStringUtf8();
            if (!database.equals(database.toLowerCase(Locale.ENGLISH))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Only lowercase database name is supported");
            }
            if (!collection.equals(collection.toLowerCase(Locale.ENGLISH))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Only lowercase collection name is supported");
            }
            SchemaTableName schemaTableName = new SchemaTableName(database, collection);
            ConnectorTableHandle tableHandle = metadata.getTableHandle(session, schemaTableName, Optional.empty(), Optional.empty());
            if (tableHandle == null) {
                throw new TableNotFoundException(schemaTableName);
            }
            RemoteTableName remoteTableName = tableHandle.remoteTableName();
            Query.parseFilter(filter);
            tableHandle = new MongoTableHandle(schemaTableName, remoteTableName, Optional.of(filter));
            ConnectorTableSchema tableSchema = metadata.getTableSchema(session, tableHandle);
            Map<String, ColumnHandle> columnsByName = metadata.getColumnHandles(session, tableHandle);
            List columns = (List)tableSchema.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnSchema::getName).map(columnsByName::get).collect(ImmutableList.toImmutableList());
            Descriptor returnedType = new Descriptor((List)columns.stream().map(MongoColumnHandle.class::cast).map(column -> new Descriptor.Field(column.baseName(), Optional.of(column.type()))).collect(ImmutableList.toImmutableList()));
            QueryFunctionHandle handle = new QueryFunctionHandle((MongoTableHandle)tableHandle);
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class QueryFunctionHandle
    implements ConnectorTableFunctionHandle {
        private final MongoTableHandle tableHandle;

        @JsonCreator
        public QueryFunctionHandle(@JsonProperty(value="tableHandle") MongoTableHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

