/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerZoneResourceMatcher;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.util.RangerResourceEvaluatorsRetriever;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSecurityZoneMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSecurityZoneMatcher.class);
    private final Map<String, RangerResourceTrie<RangerZoneResourceMatcher>> resourceZoneTrie = new HashMap<String, RangerResourceTrie<RangerZoneResourceMatcher>>();
    private final Set<String> zonesWithTagService = new HashSet<String>();
    private final RangerServiceDef serviceDef;

    public RangerSecurityZoneMatcher(Map<String, ServicePolicies.SecurityZoneInfo> securityZones, RangerServiceDef serviceDef, RangerPluginContext pluginContext) {
        this.serviceDef = serviceDef;
        this.buildZoneTrie(securityZones, serviceDef, pluginContext);
    }

    public boolean hasTagService(String zoneName) {
        return this.zonesWithTagService.contains(zoneName);
    }

    public Set<String> getZonesForResourceAndChildren(Map<String, ?> resource) {
        return this.getZonesForResourceAndChildren(resource, this.convertToAccessResource(resource));
    }

    public Set<String> getZonesForResourceAndChildren(RangerAccessResource resource) {
        return this.getZonesForResourceAndChildren(resource.getAsMap(), resource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RangerSecurityZoneMatcher other = (RangerSecurityZoneMatcher)obj;
        return Objects.equals(this.resourceZoneTrie, other.resourceZoneTrie) && Objects.equals(this.zonesWithTagService, other.zonesWithTagService);
    }

    public int hashCode() {
        return Objects.hash(this.resourceZoneTrie, this.zonesWithTagService);
    }

    private Set<String> getZonesForResourceAndChildren(Map<String, ?> resource, RangerAccessResource accessResource) {
        Collection<RangerZoneResourceMatcher> matchers;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSecurityZoneMatcher.getZonesForResourceAndChildren({})", (Object)accessResource);
        }
        HashSet<String> ret = null;
        if (MapUtils.isNotEmpty(this.resourceZoneTrie) && CollectionUtils.isNotEmpty(matchers = RangerResourceEvaluatorsRetriever.getEvaluators(this.resourceZoneTrie, resource))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource:[{}], matchers:[{}]", resource, matchers);
            }
            ret = new HashSet<String>(matchers.size());
            for (RangerZoneResourceMatcher matcher : matchers) {
                RangerPolicyResourceMatcher policyResourceMatcher;
                RangerPolicyResourceMatcher.MatchType matchType;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to match resource:[{}] using matcher:[{}]", (Object)accessResource, (Object)matcher);
                }
                if ((matchType = (policyResourceMatcher = matcher.getPolicyResourceMatcher()).getMatchType(accessResource, null)) == RangerPolicyResourceMatcher.MatchType.DESCENDANT) {
                    ret.add("");
                }
                if (matchType != RangerPolicyResourceMatcher.MatchType.NONE) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Matched resource:[{}] using matcher:[{}]", (Object)accessResource, (Object)matcher);
                    }
                    ret.add(matcher.getSecurityZoneName());
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Did not match resource:[{}] using matcher:[{}]", (Object)accessResource, (Object)matcher);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("zone-names matched resource:[{}]: {}", (Object)accessResource, ret);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSecurityZoneMatcher.getZonesForResourceAndChildren({}): ret={}", (Object)accessResource, ret);
        }
        return ret;
    }

    private void buildZoneTrie(Map<String, ServicePolicies.SecurityZoneInfo> securityZones, RangerServiceDef serviceDef, RangerPluginContext pluginContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSecurityZoneMatcher.buildZoneTrie()");
        }
        HashMap<String, Boolean> resourceIsRecursive = new HashMap<String, Boolean>();
        if (MapUtils.isNotEmpty(securityZones)) {
            ArrayList<RangerZoneResourceMatcher> matchers = new ArrayList<RangerZoneResourceMatcher>();
            for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> securityZone : securityZones.entrySet()) {
                String zoneName = securityZone.getKey();
                ServicePolicies.SecurityZoneInfo zoneDetails = securityZone.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Building matchers for zone:[{}]", (Object)zoneName);
                }
                for (Map map : zoneDetails.getResources()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Building matcher for resource:[{}] in zone:[{}]", (Object)map, (Object)zoneName);
                    }
                    HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
                    for (Map.Entry entry : map.entrySet()) {
                        String resourceDefName = (String)entry.getKey();
                        List resourceValues = (List)entry.getValue();
                        Boolean isRecursive = resourceIsRecursive.computeIfAbsent(resourceDefName, f -> EmbeddedServiceDefsUtil.isRecursiveEnabled(serviceDef, resourceDefName));
                        policyResources.put(resourceDefName, new RangerPolicy.RangerPolicyResource(resourceValues, (Boolean)false, isRecursive));
                    }
                    matchers.add(new RangerZoneResourceMatcher(zoneName, policyResources, serviceDef));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Built matcher for resource:[{}] in zone:[{}]", (Object)map, (Object)zoneName);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Built all matchers for zone:[{}]", (Object)zoneName);
                }
                if (!Boolean.TRUE.equals(zoneDetails.getContainsAssociatedTagService())) continue;
                this.zonesWithTagService.add(zoneName);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Built matchers for all Zones");
            }
            RangerPolicyEngineOptions options = pluginContext.getConfig().getPolicyEngineOptions();
            for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
                this.resourceZoneTrie.put(resourceDef.getName(), new RangerResourceTrie(resourceDef, matchers, options.optimizeTrieForSpace, options.optimizeTrieForRetrieval, pluginContext));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSecurityZoneMatcher.buildZoneTrie()");
        }
    }

    private RangerAccessResource convertToAccessResource(Map<String, ?> resource) {
        RangerAccessResourceImpl ret = new RangerAccessResourceImpl();
        ret.setServiceDef(this.serviceDef);
        for (Map.Entry<String, ?> entry : resource.entrySet()) {
            ret.setValue(entry.getKey(), entry.getValue());
        }
        return ret;
    }
}

