/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.parquet.Field;
import io.trino.parquet.GroupField;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public final class ParquetTypeUtils {
    private ParquetTypeUtils() {
    }

    public static List<PrimitiveColumnIO> getColumns(MessageType fileSchema, MessageType requestedSchema) {
        return ImmutableList.copyOf((Collection)new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true).getLeaves());
    }

    public static MessageColumnIO getColumnIO(MessageType fileSchema, MessageType requestedSchema) {
        return new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true);
    }

    public static GroupColumnIO getMapKeyValueColumn(GroupColumnIO groupColumnIO) {
        while (groupColumnIO.getChildrenCount() == 1) {
            groupColumnIO = (GroupColumnIO)groupColumnIO.getChild(0);
        }
        return groupColumnIO;
    }

    public static ColumnIO getArrayElementColumn(ColumnIO columnIO) {
        while (columnIO instanceof GroupColumnIO && !columnIO.getType().isRepetition(Type.Repetition.REPEATED)) {
            columnIO = ((GroupColumnIO)columnIO).getChild(0);
        }
        if (columnIO instanceof GroupColumnIO && columnIO.getType().getLogicalTypeAnnotation() == null && ((GroupColumnIO)columnIO).getChildrenCount() == 1 && !columnIO.getName().equals("array") && !columnIO.getName().equals(columnIO.getParent().getName() + "_tuple")) {
            return ((GroupColumnIO)columnIO).getChild(0);
        }
        return columnIO;
    }

    public static Map<List<String>, ColumnDescriptor> getDescriptors(MessageType fileSchema, MessageType requestedSchema) {
        return (Map)ParquetTypeUtils.getColumns(fileSchema, requestedSchema).stream().collect(ImmutableMap.toImmutableMap(columnIO -> Arrays.asList(columnIO.getFieldPath()), PrimitiveColumnIO::getColumnDescriptor, (oldValue, columnDescriptor) -> oldValue));
    }

    public static ParquetEncoding getParquetEncoding(Encoding encoding) {
        return switch (encoding) {
            default -> throw new MatchException(null, null);
            case Encoding.PLAIN -> ParquetEncoding.PLAIN;
            case Encoding.RLE -> ParquetEncoding.RLE;
            case Encoding.BYTE_STREAM_SPLIT -> ParquetEncoding.BYTE_STREAM_SPLIT;
            case Encoding.BIT_PACKED -> ParquetEncoding.BIT_PACKED;
            case Encoding.PLAIN_DICTIONARY -> ParquetEncoding.PLAIN_DICTIONARY;
            case Encoding.DELTA_BINARY_PACKED -> ParquetEncoding.DELTA_BINARY_PACKED;
            case Encoding.DELTA_LENGTH_BYTE_ARRAY -> ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY;
            case Encoding.DELTA_BYTE_ARRAY -> ParquetEncoding.DELTA_BYTE_ARRAY;
            case Encoding.RLE_DICTIONARY -> ParquetEncoding.RLE_DICTIONARY;
        };
    }

    public static Type getParquetTypeByName(String columnName, GroupType groupType) {
        if (groupType.containsField(columnName)) {
            return groupType.getType(columnName);
        }
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(columnName)) continue;
            return type;
        }
        return null;
    }

    public static ColumnIO lookupColumnByName(GroupColumnIO groupColumnIO, String columnName) {
        ColumnIO columnIO = groupColumnIO.getChild(columnName);
        if (columnIO != null) {
            return columnIO;
        }
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            if (!groupColumnIO.getChild(i).getName().equalsIgnoreCase(columnName)) continue;
            return groupColumnIO.getChild(i);
        }
        return null;
    }

    @Nullable
    public static ColumnIO lookupColumnById(GroupColumnIO groupColumnIO, int columnId) {
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            ColumnIO child = groupColumnIO.getChild(i);
            if (child.getType().getId().intValue() != columnId) continue;
            return child;
        }
        return null;
    }

    public static Optional<DecimalType> createDecimalType(PrimitiveField field) {
        LogicalTypeAnnotation logicalTypeAnnotation = field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
        if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
            return Optional.empty();
        }
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
        return Optional.of(DecimalType.createDecimalType((int)decimalLogicalType.getPrecision(), (int)decimalLogicalType.getScale()));
    }

    public static boolean isValueNull(boolean required, int definitionLevel, int maxDefinitionLevel) {
        return !required && definitionLevel == maxDefinitionLevel - 1;
    }

    public static boolean isOptionalFieldValueNull(int definitionLevel, int maxDefinitionLevel) {
        return definitionLevel == maxDefinitionLevel - 1;
    }

    public static long getShortDecimalValue(byte[] bytes) {
        return ParquetTypeUtils.getShortDecimalValue(bytes, 0, bytes.length);
    }

    public static long getShortDecimalValue(byte[] bytes, int startOffset, int length) {
        long value = 0L;
        switch (length) {
            case 8: {
                value |= (long)bytes[startOffset + 7] & 0xFFL;
            }
            case 7: {
                value |= ((long)bytes[startOffset + 6] & 0xFFL) << 8;
            }
            case 6: {
                value |= ((long)bytes[startOffset + 5] & 0xFFL) << 16;
            }
            case 5: {
                value |= ((long)bytes[startOffset + 4] & 0xFFL) << 24;
            }
            case 4: {
                value |= ((long)bytes[startOffset + 3] & 0xFFL) << 32;
            }
            case 3: {
                value |= ((long)bytes[startOffset + 2] & 0xFFL) << 40;
            }
            case 2: {
                value |= ((long)bytes[startOffset + 1] & 0xFFL) << 48;
            }
            case 1: {
                value |= ((long)bytes[startOffset] & 0xFFL) << 56;
            }
        }
        return value >>= (8 - length) * 8;
    }

    public static void checkBytesFitInShortDecimal(byte[] bytes, int offset, int length, ColumnDescriptor descriptor) {
        int endOffset = offset + length;
        byte expectedValue = (byte)(bytes[endOffset] >> 7);
        for (int i = offset; i < endOffset; ++i) {
            if (bytes[i] == expectedValue) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not read unscaled value %s into a short decimal from column %s", new BigInteger(bytes, offset, length + 8), descriptor));
        }
    }

    public static byte[] paddingBigInteger(BigInteger bigInteger, int numBytes) {
        byte[] bytes = bigInteger.toByteArray();
        if (bytes.length == numBytes) {
            return bytes;
        }
        byte[] result = new byte[numBytes];
        if (bigInteger.signum() < 0) {
            Arrays.fill(result, 0, numBytes - bytes.length, (byte)-1);
        }
        System.arraycopy(bytes, 0, result, numBytes - bytes.length, bytes.length);
        return result;
    }

    public static Optional<Field> constructField(io.trino.spi.type.Type type, ColumnIO columnIO) {
        return ParquetTypeUtils.constructField(type, columnIO, true);
    }

    private static Optional<Field> constructField(io.trino.spi.type.Type type, ColumnIO columnIO, boolean isTopLevel) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = columnIO.getRepetitionLevel();
        int definitionLevel = columnIO.getDefinitionLevel();
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = rowType.getFields();
            boolean structHasParameters = false;
            for (RowType.Field rowField : fields) {
                String name = ((String)rowField.getName().orElseThrow()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = ParquetTypeUtils.constructField(rowField.getType(), ParquetTypeUtils.lookupColumnByName(groupColumnIO, name), false);
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List<Optional<Field>>)fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn(groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = ParquetTypeUtils.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0), false);
            Optional<Field> valueField = ParquetTypeUtils.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1), false);
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List<Optional<Field>>)ImmutableList.of(keyField, valueField)));
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (columnIO instanceof PrimitiveColumnIO) {
                PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
                if (columnIO.getType().getRepetition() != Type.Repetition.REPEATED || repetitionLevel == 0 || definitionLevel == 0) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported schema for Parquet column (%s)", primitiveColumnIO.getColumnDescriptor()));
                }
                PrimitiveField primitiveFieldElement = new PrimitiveField(arrayType.getElementType(), true, primitiveColumnIO.getColumnDescriptor(), primitiveColumnIO.getId());
                return Optional.of(new GroupField(type, repetitionLevel - 1, definitionLevel - 1, true, (List<Optional<Field>>)ImmutableList.of(Optional.of(primitiveFieldElement))));
            }
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            Optional<Field> field = ParquetTypeUtils.constructField(arrayType.getElementType(), ParquetTypeUtils.getArrayElementColumn(groupColumnIO.getChild(0)), false);
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List<Optional<Field>>)ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        if (primitiveColumnIO.getType().getRepetition() == Type.Repetition.REPEATED && isTopLevel) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", type, primitiveColumnIO.getColumnDescriptor()));
        }
        return Optional.of(new PrimitiveField(type, required, primitiveColumnIO.getColumnDescriptor(), primitiveColumnIO.getId()));
    }
}

