/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.dictionary.Dictionary;

public class BinaryDictionary
implements Dictionary {
    private final Slice[] content;

    public BinaryDictionary(DictionaryPage dictionaryPage) {
        this(dictionaryPage, null);
    }

    public BinaryDictionary(DictionaryPage dictionaryPage, Integer length) {
        this.content = new Slice[dictionaryPage.getDictionarySize()];
        Slice dictionarySlice = dictionaryPage.getSlice();
        int currentInputOffset = 0;
        if (length == null) {
            for (int i = 0; i < this.content.length; ++i) {
                int positionLength = dictionarySlice.getInt(currentInputOffset);
                this.content[i] = dictionarySlice.slice(currentInputOffset += 4, positionLength);
                currentInputOffset += positionLength;
            }
        } else {
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (String)"Invalid byte array length: %s", (Object)length);
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = dictionarySlice.slice(currentInputOffset, length.intValue());
                currentInputOffset += length.intValue();
            }
        }
    }

    @Override
    public Slice decodeToSlice(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

