/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.ChunkReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public final class ChunkedInputStream
extends InputStream {
    private final Iterator<? extends ChunkReader> chunks;
    private ChunkReader currentChunkReader;
    private BasicSliceInput current = Slices.EMPTY_SLICE.getInput();

    public ChunkedInputStream(Collection<? extends ChunkReader> chunks) {
        Objects.requireNonNull(chunks, "chunks is null");
        Preconditions.checkArgument((!chunks.isEmpty() ? 1 : 0) != 0, (Object)"At least one chunk is expected but got none");
        this.chunks = chunks.iterator();
    }

    public Slice getSlice(int length) throws IOException {
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        this.ensureOpen();
        while (!this.current.isReadable()) {
            Preconditions.checkArgument((boolean)this.chunks.hasNext(), (String)"Requested %s bytes but 0 was available", (int)length);
            this.readNextChunk();
        }
        if (this.current.available() >= length) {
            return this.current.readSlice(length);
        }
        byte[] bytes = new byte[length];
        try {
            int read = this.readNBytes(bytes, 0, bytes.length);
            Verify.verify((read == length ? 1 : 0) != 0, (String)"expected to read %s bytes but got %s", (int)length, (int)read);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + length + " bytes", e);
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkPositionIndexes((int)off, (int)(off + len), (int)b.length);
        if (len == 0) {
            return 0;
        }
        this.ensureOpen();
        while (!this.current.isReadable()) {
            if (!this.chunks.hasNext()) {
                return -1;
            }
            this.readNextChunk();
        }
        return this.current.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        while (!this.current.isReadable() && this.chunks.hasNext()) {
            this.readNextChunk();
        }
        return this.current.read();
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.current.available();
    }

    @Override
    public void close() {
        if (this.current == null) {
            return;
        }
        if (this.currentChunkReader != null) {
            this.currentChunkReader.free();
        }
        while (this.chunks.hasNext()) {
            this.chunks.next().free();
        }
        this.current = null;
    }

    private void ensureOpen() throws IOException {
        if (this.current == null) {
            throw new IOException("Stream closed");
        }
    }

    private void readNextChunk() {
        if (this.currentChunkReader != null) {
            this.currentChunkReader.free();
        }
        this.currentChunkReader = this.chunks.next();
        Slice slice = this.currentChunkReader.readUnchecked();
        Preconditions.checkArgument((slice.length() > 0 ? 1 : 0) != 0, (Object)"all chunks have to be not empty");
        this.current = slice.getInput();
    }
}

