/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.airlift.slice.SizeOf;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.spi.block.Block;
import io.trino.spi.block.ByteArrayBlock;
import java.util.List;
import java.util.Optional;

public class ByteColumnAdapter
implements ColumnAdapter<byte[]> {
    public static final ByteColumnAdapter BYTE_ADAPTER = new ByteColumnAdapter();

    @Override
    public byte[] createBuffer(int size) {
        return new byte[size];
    }

    @Override
    public Block createNonNullBlock(byte[] values) {
        return new ByteArrayBlock(values.length, Optional.empty(), values);
    }

    @Override
    public Block createNullableBlock(boolean[] nulls, byte[] values) {
        return new ByteArrayBlock(values.length, Optional.of(nulls), values);
    }

    @Override
    public void copyValue(byte[] source, int sourceIndex, byte[] destination, int destinationIndex) {
        destination[destinationIndex] = source[sourceIndex];
    }

    @Override
    public void decodeDictionaryIds(byte[] values, int offset, int length, int[] ids, byte[] dictionary) {
        for (int i = 0; i < length; ++i) {
            values[offset + i] = dictionary[ids[i]];
        }
    }

    @Override
    public long getSizeInBytes(byte[] values) {
        return SizeOf.sizeOf((byte[])values);
    }

    @Override
    public byte[] merge(List<byte[]> buffers) {
        long resultSize = 0L;
        for (byte[] buffer : buffers) {
            resultSize += (long)buffer.length;
        }
        byte[] result = new byte[Math.toIntExact(resultSize)];
        int offset = 0;
        for (byte[] buffer : buffers) {
            System.arraycopy(buffer, 0, result, offset, buffer.length);
            offset += buffer.length;
        }
        return result;
    }
}

