/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.parquet.writer.ColumnChunk;
import io.trino.parquet.writer.ColumnWriter;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.parquet.writer.repdef.DefLevelWriterProviders;
import io.trino.parquet.writer.repdef.RepLevelWriterProvider;
import io.trino.parquet.writer.repdef.RepLevelWriterProviders;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.Preconditions;

public class StructColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(StructColumnWriter.class);
    private final List<ColumnWriter> columnWriters;
    private final int maxDefinitionLevel;

    public StructColumnWriter(List<ColumnWriter> columnWriters, int maxDefinitionLevel) {
        this.columnWriters = Objects.requireNonNull(columnWriters, "columnWriters is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        Block block = columnChunk.getBlock();
        List fields = RowBlock.getNullSuppressedRowFieldsFromBlock((Block)block);
        Preconditions.checkArgument((fields.size() == this.columnWriters.size() ? 1 : 0) != 0, (String)"Row field size %s is not equal to columnWriters size %s", (Object)fields.size(), (Object)this.columnWriters.size());
        ImmutableList defLevelWriterProviders = ImmutableList.builder().addAll(columnChunk.getDefLevelWriterProviders()).add((Object)DefLevelWriterProviders.of(block, this.maxDefinitionLevel)).build();
        ImmutableList repLevelWriterProviders = ImmutableList.builder().addAll(columnChunk.getRepLevelWriterProviders()).add((Object)RepLevelWriterProviders.of(block)).build();
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            ColumnWriter columnWriter = this.columnWriters.get(i);
            Block field = (Block)fields.get(i);
            columnWriter.writeBlock(new ColumnChunk(field, (List<DefLevelWriterProvider>)defLevelWriterProviders, (List<RepLevelWriterProvider>)repLevelWriterProviders));
        }
    }

    @Override
    public void close() {
        this.columnWriters.forEach(ColumnWriter::close);
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnWriter columnWriter : this.columnWriters) {
            builder.addAll(columnWriter.getBuffer());
        }
        return builder.build();
    }

    @Override
    public long getBufferedBytes() {
        long bufferedBytes = 0L;
        for (ColumnWriter columnWriter : this.columnWriters) {
            bufferedBytes += columnWriter.getBufferedBytes();
        }
        return bufferedBytes;
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.columnWriters.stream().mapToLong(ColumnWriter::getRetainedBytes).sum();
    }
}

